/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.model.EventConfEvent;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.EventLabelComparator;
import org.opennms.netmgt.xml.eventconf.EventMatchers;
import org.opennms.netmgt.xml.eventconf.EventOrdering;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.Field;
import org.opennms.netmgt.xml.eventconf.Global;
import org.opennms.netmgt.xml.eventconf.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;

public class DefaultEventConfDao
implements EventConfDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventConfDao.class);
    private Events m_events = new Events();
    private Partition m_partition = new EnterpriseIdPartition();
    private Resource m_configResource;

    public DefaultEventConfDao() {
        this.m_events.initialize(this.m_partition, new EventOrdering());
    }

    public void reload() throws DataAccessException {
    }

    public List<Event> getEvents(String uei) {
        List<Event> events = ((List)this.m_events.forEachEvent(new ArrayList(), (accum, event) -> {
            if (uei.equals(event.getUei())) {
                accum.add(event);
            }
            return accum;
        })).stream().distinct().collect(Collectors.toList());
        return events.isEmpty() ? null : events;
    }

    public List<String> getEventUEIs() {
        return (List)this.m_events.forEachEvent(new ArrayList(), (Events.EventCallback)new Events.EventCallback<List<String>>(){

            public List<String> process(List<String> ueis, Event event) {
                ueis.add(event.getUei());
                return ueis;
            }
        });
    }

    public Map<String, String> getEventLabels() {
        return (Map)this.m_events.forEachEvent(new TreeMap(), (Events.EventCallback)new Events.EventCallback<Map<String, String>>(){

            public Map<String, String> process(Map<String, String> ueiToLabelMap, Event event) {
                ueiToLabelMap.put(event.getUei(), event.getEventLabel());
                return ueiToLabelMap;
            }
        });
    }

    public String getEventLabel(String uei) {
        Event event = this.m_events.getEventByUeiOptimistic(uei);
        if (event == null) {
            event = this.findByUei(uei);
        }
        return event == null ? null : event.getEventLabel();
    }

    public List<Event> getAllEvents() {
        return ((List)this.m_events.forEachEvent(new ArrayList(), (accum, event) -> {
            accum.add(event);
            return accum;
        })).stream().distinct().collect(Collectors.toList());
    }

    public List<Event> getEventsByLabel() {
        SortedSet events = (SortedSet)this.m_events.forEachEvent(new TreeSet(new EventLabelComparator()), (Events.EventCallback)new Events.EventCallback<SortedSet<Event>>(){

            public SortedSet<Event> process(SortedSet<Event> accum, Event event) {
                accum.add(event);
                return accum;
            }
        });
        return new ArrayList<Event>(events);
    }

    public void addEvent(Event event) {
        this.m_events.addEvent(event);
        this.m_events.initialize(this.m_partition, new EventOrdering());
    }

    public boolean isSecureTag(String tag) {
        return this.m_events.isSecureTag(tag);
    }

    public Event findByUei(final String uei) {
        if (uei == null) {
            return null;
        }
        return this.m_events.findFirstMatchingEvent(new Events.EventCriteria(){

            public boolean matches(Event e) {
                return uei.equals(e.getUei());
            }
        });
    }

    public Event findByEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
        return this.m_events.findFirstMatchingEvent(matchingEvent);
    }

    public Events getRootEvents() {
        return this.m_events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEventsFromDB(List<EventConfEvent> dbEvents) {
        Map eventsBySource = dbEvents.stream().collect(Collectors.groupingBy(event -> event.getSource().getName(), LinkedHashMap::new, Collectors.toList()));
        List<Map.Entry<String, List<EventConfEvent>>> sortedSources = this.sortSourcesByFileOrder(eventsBySource);
        Events rootEvents = new Events();
        Global global = this.loadGlobalFromEventConfXml();
        if (global != null) {
            rootEvents.setGlobal(global);
        }
        for (Map.Entry<String, List<EventConfEvent>> sourceEntry : sortedSources) {
            Events eventsForSource = this.buildEventsForSource(sourceEntry.getValue());
            rootEvents.addLoadedEventFile(sourceEntry.getKey(), eventsForSource);
        }
        DefaultEventConfDao defaultEventConfDao = this;
        synchronized (defaultEventConfDao) {
            this.m_partition = new EnterpriseIdPartition();
            rootEvents.initialize(this.m_partition, new EventOrdering());
            this.m_events = rootEvents;
        }
    }

    private Global loadGlobalFromEventConfXml() {
        try {
            Events events;
            Resource resource = this.m_configResource;
            if (resource == null) {
                File eventConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENT_CONF_FILE_NAME);
                resource = new FileSystemResource(eventConfFile);
            }
            if ((events = (Events)JaxbUtils.unmarshal(Events.class, (Resource)resource)) != null) {
                return events.getGlobal();
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to load global settings from eventconf.xml: {}", (Object)e.getMessage());
        }
        return null;
    }

    private List<Map.Entry<String, List<EventConfEvent>>> sortSourcesByFileOrder(Map<String, List<EventConfEvent>> eventsBySource) {
        return eventsBySource.entrySet().stream().sorted(Map.Entry.comparingByValue((events1, events2) -> {
            Integer order1 = ((EventConfEvent)events1.get(0)).getSource().getFileOrder();
            Integer order2 = ((EventConfEvent)events2.get(0)).getSource().getFileOrder();
            return Integer.compare(order2 != null ? order2 : 0, order1 != null ? order1 : 0);
        })).toList();
    }

    private Events buildEventsForSource(List<EventConfEvent> sourceEvents) {
        Events eventsForSource = new Events();
        for (EventConfEvent dbEvent : sourceEvents) {
            this.parseAndAddEvent(eventsForSource, dbEvent);
        }
        return eventsForSource;
    }

    private void parseAndAddEvent(Events eventsForSource, EventConfEvent dbEvent) {
        String xmlContent = dbEvent.getXmlContent();
        if (xmlContent != null && !xmlContent.trim().isEmpty()) {
            try {
                Event event = (Event)JaxbUtils.unmarshal(Event.class, (String)xmlContent);
                if (event != null) {
                    eventsForSource.addEvent(event);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to parse event XML content for UEI {}", (Object)dbEvent.getUei(), (Object)e);
            }
        }
    }

    public void afterPropertiesSet() throws DataAccessException {
    }

    @VisibleForTesting
    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    private static class EnterpriseIdPartition
    implements Partition {
        private Field m_field = EventMatchers.field((String)"id");

        private EnterpriseIdPartition() {
        }

        public List<String> group(Event eventConf) {
            List keys = eventConf.getMaskElementValues("id");
            if (keys == null) {
                return null;
            }
            for (String key : keys) {
                if (key.endsWith("%")) {
                    return null;
                }
                if (!key.startsWith("~")) continue;
                return null;
            }
            return keys;
        }

        public String group(org.opennms.netmgt.xml.event.Event matchingEvent) {
            return this.m_field.get(matchingEvent);
        }
    }
}

