/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.proxy.PingResponseDTO;

public class PingResultTracker
extends CompletableFuture<PingResponseDTO>
implements PingResponseCallback {
    public void handleResponse(InetAddress address, EchoPacket response) {
        PingResponseDTO responseDTO = new PingResponseDTO();
        responseDTO.setRtt(response.elapsedTime(TimeUnit.MILLISECONDS));
        this.complete(responseDTO);
    }

    public void handleTimeout(InetAddress address, EchoPacket request) {
        PingResponseDTO responseDTO = new PingResponseDTO();
        responseDTO.setRtt(Double.POSITIVE_INFINITY);
        if (!this.isDone()) {
            this.complete(responseDTO);
        }
    }

    public void handleError(InetAddress address, EchoPacket request, Throwable t) {
        if (!this.isDone()) {
            this.completeExceptionally(t);
        }
    }
}

