/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.ApiOperation;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApiOperationMatch {
    public static ApiOperationMatch MISSING_PATH = new ApiOperationMatch(false, false, null);
    public static ApiOperationMatch NOT_ALLOWED_OPERATION = new ApiOperationMatch(true, false, null);
    private final boolean pathFound;
    private final boolean operationAllowed;
    private final ApiOperation apiOperation;

    public ApiOperationMatch(@Nonnull ApiOperation apiOperation) {
        this(true, true, apiOperation);
    }

    private ApiOperationMatch(boolean pathFound, boolean operationAllowed, @Nullable ApiOperation apiOperation) {
        this.pathFound = pathFound;
        this.operationAllowed = operationAllowed;
        if (pathFound && operationAllowed) {
            Objects.requireNonNull(apiOperation, "A path string is required");
        }
        this.apiOperation = apiOperation;
    }

    public boolean isPathFound() {
        return this.pathFound;
    }

    public boolean isOperationAllowed() {
        return this.operationAllowed;
    }

    public ApiOperation getApiOperation() {
        if (!this.pathFound || !this.operationAllowed) {
            throw new IllegalStateException("No API operation found.");
        }
        return this.apiOperation;
    }
}

