/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.ApiPath;
import com.atlassian.oai.validator.model.NormalisedPath;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ApiOperation {
    private final ApiPath apiPath;
    private final NormalisedPath requestPath;
    private final PathItem.HttpMethod method;
    private final Operation operation;

    public ApiOperation(@Nonnull ApiPath apiPath, @Nonnull NormalisedPath requestPath, @Nonnull PathItem.HttpMethod method, @Nonnull Operation operation) {
        this.apiPath = Objects.requireNonNull(apiPath, "A path string is required");
        this.requestPath = Objects.requireNonNull(requestPath, "An api path is required");
        this.method = Objects.requireNonNull(method, "A request method is required");
        this.operation = Objects.requireNonNull(operation, "A operation object is required");
    }

    @Nonnull
    public ApiPath getApiPath() {
        return this.apiPath;
    }

    @Nonnull
    public NormalisedPath getRequestPath() {
        return this.requestPath;
    }

    @Nonnull
    public PathItem.HttpMethod getMethod() {
        return this.method;
    }

    @Nonnull
    public Operation getOperation() {
        return this.operation;
    }
}

