/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.interaction;

import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.ApiOperationMatch;
import com.atlassian.oai.validator.model.ApiPath;
import com.atlassian.oai.validator.model.ApiPathImpl;
import com.atlassian.oai.validator.model.NormalisedPath;
import com.atlassian.oai.validator.model.NormalisedPathImpl;
import com.atlassian.oai.validator.model.Request;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiOperationResolver {
    private static final Logger log = LoggerFactory.getLogger(ApiOperationResolver.class);
    private final String apiPrefix;
    private final Map<Integer, List<ApiPath>> apiPathsGroupedByNumberOfParts;
    private final Table<String, PathItem.HttpMethod, Operation> operations;

    public ApiOperationResolver(OpenAPI api, @Nullable String basePathOverride, boolean strictPathMatching) {
        this.apiPrefix = Optional.ofNullable(basePathOverride).orElse(ApiOperationResolver.getBasePathFrom(api.getServers()));
        Paths apiPaths = Optional.ofNullable(api.getPaths()).orElse(new Paths());
        this.apiPathsGroupedByNumberOfParts = apiPaths.keySet().stream().map(p -> new ApiPathImpl((String)p, this.apiPrefix, strictPathMatching)).collect(Collectors.groupingBy(NormalisedPath::numberOfParts));
        this.operations = HashBasedTable.create();
        apiPaths.forEach((pathKey, apiPath) -> apiPath.readOperationsMap().forEach((httpMethod, operation) -> this.operations.put(pathKey, httpMethod, operation)));
    }

    @Nonnull
    public ApiOperationMatch findApiOperation(String path, Request.Method method) {
        NormalisedPathImpl requestPath = new NormalisedPathImpl(path, this.apiPrefix);
        List matchingPaths = this.apiPathsGroupedByNumberOfParts.getOrDefault(requestPath.numberOfParts(), Collections.emptyList()).stream().filter(p -> p.matches(requestPath)).collect(Collectors.toList());
        if (matchingPaths.isEmpty()) {
            return ApiOperationMatch.MISSING_PATH;
        }
        PathItem.HttpMethod httpMethod = PathItem.HttpMethod.valueOf((String)method.name());
        List matchingPathAndMethod = matchingPaths.stream().filter(apiPath -> this.operations.contains((Object)apiPath.original(), (Object)httpMethod)).collect(Collectors.toList());
        if (matchingPathAndMethod.isEmpty()) {
            return ApiOperationMatch.NOT_ALLOWED_OPERATION;
        }
        Optional<ApiPath> exactMatch = matchingPathAndMethod.stream().filter(apiPath -> apiPath.normalised().equalsIgnoreCase(requestPath.normalised())).findFirst();
        if (exactMatch.isPresent()) {
            return new ApiOperationMatch(new ApiOperation(exactMatch.get(), requestPath, httpMethod, (Operation)this.operations.get((Object)exactMatch.get().original(), (Object)httpMethod)));
        }
        Optional<ApiPath> scoredMatch = matchingPathAndMethod.stream().max(Comparator.comparingInt(ApiOperationResolver::specificityScore));
        return scoredMatch.map(match -> new ApiOperationMatch(new ApiOperation((ApiPath)match, requestPath, httpMethod, (Operation)this.operations.get((Object)match.original(), (Object)httpMethod)))).orElse(ApiOperationMatch.NOT_ALLOWED_OPERATION);
    }

    private static int specificityScore(ApiPath apiPath) {
        return apiPath.normalised().replaceAll("\\{.+?}", "").length();
    }

    @Nonnull
    @VisibleForTesting
    static String getBasePathFrom(@Nullable List<Server> servers) {
        if (servers == null) {
            return "/";
        }
        return servers.stream().filter(Objects::nonNull).map(ApiOperationResolver::substituteUrlVariables).map(ApiOperationResolver::gePathFrom).filter(Objects::nonNull).findFirst().orElse("/");
    }

    private static String gePathFrom(String serverUrl) {
        try {
            return new URI(serverUrl).getPath();
        }
        catch (URISyntaxException e) {
            log.debug("Server URL {} not a valid URI", (Object)serverUrl);
            return serverUrl;
        }
    }

    private static String substituteUrlVariables(Server server) {
        String result = server.getUrl();
        if (result == null) {
            return "/";
        }
        if (server.getVariables() == null) {
            return result;
        }
        for (String varName : server.getVariables().keySet()) {
            String value = (String)StringUtils.defaultIfBlank((CharSequence)((ServerVariable)server.getVariables().get((Object)varName)).getDefault(), (CharSequence)"");
            result = result.replace(String.format("{%s}", varName), value);
        }
        return result;
    }
}

