/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.annotations.Exposable;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.DataPoint;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TagMatcher;
import org.opennms.integration.api.v1.timeseries.TimeSeriesData;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;

@Exposable
public interface TimeSeriesStorage {
    public void store(List<Sample> var1) throws StorageException;

    public List<Metric> findMetrics(Collection<TagMatcher> var1) throws StorageException;

    @Deprecated
    public List<Sample> getTimeseries(TimeSeriesFetchRequest var1) throws StorageException;

    default public TimeSeriesData getTimeSeriesData(TimeSeriesFetchRequest request) throws StorageException {
        List<Sample> samples = this.getTimeseries(request);
        Metric metric = samples.isEmpty() ? request.getMetric() : samples.get(0).getMetric();
        List<DataPoint> dataPoints = samples.stream().map(s -> new DataPointImpl(s.getTime(), s.getValue())).collect(Collectors.toList());
        return new TimeSeriesDataimpl(metric, dataPoints);
    }

    public void delete(Metric var1) throws StorageException;

    default public boolean supportsAggregation(Aggregation aggregation) {
        return aggregation == Aggregation.NONE;
    }

    @Deprecated
    public static class TimeSeriesDataimpl
    implements TimeSeriesData {
        private final Metric metric;
        private final List<DataPoint> dataPoints;

        public TimeSeriesDataimpl(Metric metric, List<DataPoint> dataPoints) {
            this.metric = Objects.requireNonNull(metric);
            this.dataPoints = Objects.requireNonNull(dataPoints);
        }

        @Override
        public Metric getMetric() {
            return this.metric;
        }

        @Override
        public List<DataPoint> getDataPoints() {
            return this.dataPoints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesDataimpl that = (TimeSeriesDataimpl)o;
            return Objects.equals(this.metric, that.metric) && Objects.equals(this.dataPoints, that.dataPoints);
        }

        public int hashCode() {
            return Objects.hash(this.metric, this.dataPoints);
        }

        public String toString() {
            return "TimeSeriesDataImpl{metric=" + this.metric + ", dataPoints=" + this.dataPoints + "}";
        }
    }

    @Deprecated
    public static class DataPointImpl
    implements DataPoint,
    Serializable {
        private final Instant time;
        private final Double value;

        public DataPointImpl(Instant time, Double value) {
            this.time = Objects.requireNonNull(time);
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public Instant getTime() {
            return this.time;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sample)) {
                return false;
            }
            Sample that = (Sample)o;
            return Objects.equals(this.time, that.getTime()) && Objects.equals(this.value, that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.time, this.value);
        }
    }
}

