/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.enlinkd.shell;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.enlinkd.snmp.CdpCacheTableTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpGlobalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpTracker;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpVlanTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBasePortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBaseTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dStpPortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1qTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IpNetToMediaTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisCircTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisISAdjTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisSysObjectGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalTableTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.enlinkd.snmp.MtxrLldpRemTableTracker;
import org.opennms.netmgt.enlinkd.snmp.MtxrNeighborTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfAreaTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfGeneralGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIfTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfNbrTableTracker;
import org.opennms.netmgt.enlinkd.snmp.TimeTetraLldpRemTableTracker;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;

@Command(scope="opennms", name="enlinkd-snmp-collect", description="Collect enlinkd snmp data")
@Service
public class SnmpCollectorCommand
implements Action,
Completer {
    @Reference
    private LocationAwareSnmpClient m_client;
    @Option(name="-l", aliases={"--location"}, description="Location")
    String location;
    private static final String CISCO_VTP = "CiscoVtp";
    private static final String CISCO_VTP_VLAN_TABLE = "CiscoVtpVlanTable";
    private static final String DOT1D_BASE = "Dot1dBase";
    private static final String DOT1D_BASE_PORT_TABLE = "Dot1dBasePortTable";
    private static final String DOT1D_STP_PORT_TABLE = "Dot1dStpPortTable";
    private static final String DOT1D_TP_FDB_TABLE = "Dot1dTpFdbTable";
    private static final String DOT1Q_TP_FDB_TABLE = "Dot1qTpFdbTable";
    private static final String CDP_GLOBAL_GROUP = "CdpGlobalGroup";
    private static final String CDP_CACHE_TABLE = "CdpCacheTable";
    private static final String IP_NET_TO_MEDIA_TABLE = "IpNetToMediaTable";
    private static final String ISIS_SYS_OBJECT_GROUP = "IsisSysObjectGroup";
    private static final String ISIS_CIRC_TABLE = "IsisCircTable";
    private static final String ISIS_IS_ADJ_TABLE = "IsisISAdjTable";
    private static final String OSPF_GENERAL_GROUP = "OspfGeneralGroup";
    private static final String OSPF_AREA_TABLE = "OspfAreaTable";
    private static final String OSPF_IF_TABLE = "OspfIfTable";
    private static final String OSPF_NBR_TABLE = "OspfNbrTable";
    private static final String LLDP_LOCAL_GROUP = "LldpLocalGroup";
    private static final String LLDP_LOCAL_TABLE = "LldpLocalTable";
    private static final String LLDP_REM_TABLE = "LldpRemTable";
    private static final String MTXR_LLDP_REM_TABLE = "MtxrLldpRemTable";
    private static final String MTXR_NEIGHBOR_TABLE = "MtxrNeighborTable";
    private static final String TIME_TETRA_LLDP_REM_TABLE = "TimeTetraLldpRemTable";
    private static final String[] trackerClassNames = new String[]{"CiscoVtp", "CiscoVtpVlanTable", "Dot1dBase", "Dot1dBasePortTable", "Dot1dStpPortTable", "Dot1dTpFdbTable", "Dot1qTpFdbTable", "CdpGlobalGroup", "CdpCacheTable", "IpNetToMediaTable", "IsisSysObjectGroup", "IsisCircTable", "IsisISAdjTable", "LldpLocalGroup", "LldpLocalTable", "LldpRemTable", "MtxrLldpRemTable", "MtxrNeighborTable", "TimeTetraLldpRemTable", "OspfGeneralGroup", "OspfAreaTable", "OspfIfTable", "OspfNbrTable"};
    @Argument(name="trackerClass", description="Tracker Collector class", required=true)
    @Completion(value=SnmpCollectorCommand.class)
    String className;
    @Argument(index=1, name="host", description="Hostname or IP Address of the system to poll", required=true)
    String host;

    public static CollectionTracker getByClassName(String name) {
        switch (name) {
            case "CiscoVtp": {
                return new CiscoVtpTracker();
            }
            case "CiscoVtpVlanTable": {
                return new CiscoVtpVlanTableTracker();
            }
            case "Dot1dBase": {
                return new Dot1dBaseTracker();
            }
            case "Dot1dBasePortTable": {
                return new Dot1dBasePortTableTracker();
            }
            case "Dot1dStpPortTable": {
                return new Dot1dStpPortTableTracker();
            }
            case "Dot1dTpFdbTable": {
                return new Dot1dTpFdbTableTracker();
            }
            case "Dot1qTpFdbTable": {
                return new Dot1qTpFdbTableTracker();
            }
            case "CdpGlobalGroup": {
                return new CdpGlobalGroupTracker();
            }
            case "CdpCacheTable": {
                return new CdpCacheTableTracker();
            }
            case "IpNetToMediaTable": {
                return new IpNetToMediaTableTracker();
            }
            case "IsisSysObjectGroup": {
                return new IsisSysObjectGroupTracker();
            }
            case "IsisCircTable": {
                return new IsisCircTableTracker();
            }
            case "IsisISAdjTable": {
                return new IsisISAdjTableTracker();
            }
            case "LldpLocalGroup": {
                return new LldpLocalGroupTracker();
            }
            case "LldpLocalTable": {
                return new LldpLocalTableTracker();
            }
            case "LldpRemTable": {
                return new LldpRemTableTracker();
            }
            case "MtxrLldpRemTable": {
                return new MtxrLldpRemTableTracker();
            }
            case "MtxrNeighborTable": {
                return new MtxrNeighborTableTracker();
            }
            case "TimeTetraLldpRemTable": {
                return new TimeTetraLldpRemTableTracker();
            }
            case "OspfGeneralGroup": {
                return new OspfGeneralGroupTracker();
            }
            case "OspfAreaTable": {
                return new OspfAreaTableTracker();
            }
            case "OspfIfTable": {
                return new OspfIfTableTracker();
            }
            case "OspfNbrTable": {
                return new OspfNbrTableTracker();
            }
        }
        return null;
    }

    public Void execute() throws UnknownHostException {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(this.host));
        String trackerName = this.className + "Tracker";
        CollectionTracker tracker = SnmpCollectorCommand.getByClassName(this.className);
        if (tracker == null) {
            System.out.printf("className %s, not found a suitable collectionTracker", this.className);
            return null;
        }
        try {
            this.m_client.walk(config, tracker).withDescription(trackerName).withLocation(this.location).execute().get();
        }
        catch (InterruptedException | ExecutionException e) {
            System.out.println("(Empty collection set)");
        }
        if (tracker instanceof AggregateTracker) {
            ((AggregateTracker)tracker).printSnmpData();
        }
        return null;
    }

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter serviceNames = new StringsCompleter();
        serviceNames.getStrings().addAll(Arrays.asList(trackerClassNames));
        return serviceNames.complete(session, commandLine, candidates);
    }
}

