/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.enlinkd.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.enlinkd.shell.ProtocolCompleter;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.enlinkd.api.ReloadableTopologyDaemon;

@Command(scope="opennms", name="enlinkd-run-collection", description="Execute a linkd snmp data collection and persist")
@Service
public class NodeCollectionCommand
implements Action {
    @Option(name="-n", aliases={"--node"}, description="Node ID or FS:FID", required=true)
    private String node;
    @Argument(name="protocol", description="type of protocol (cdp | isis | lldp | ospf | bridge ).", required=true)
    @Completion(value=ProtocolCompleter.class)
    private String protocol;
    @Reference
    private ReloadableTopologyDaemon reloadableTopologyDaemon;
    @Reference
    private EnhancedLinkdConfig enhancedLinkdConfig;

    public Void execute() {
        boolean protocolNotEnabled = true;
        boolean protocolNotSupported = false;
        switch (this.protocol) {
            case "cdp": {
                if (!this.enhancedLinkdConfig.useCdpDiscovery()) break;
                protocolNotEnabled = false;
                break;
            }
            case "lldp": {
                if (!this.enhancedLinkdConfig.useLldpDiscovery()) break;
                protocolNotEnabled = false;
                break;
            }
            case "bridge": {
                if (!this.enhancedLinkdConfig.useBridgeDiscovery()) break;
                protocolNotEnabled = false;
                break;
            }
            case "ospf": {
                if (!this.enhancedLinkdConfig.useOspfDiscovery()) break;
                protocolNotEnabled = false;
                break;
            }
            case "isis": {
                if (!this.enhancedLinkdConfig.useIsisDiscovery()) break;
                protocolNotEnabled = false;
                break;
            }
            default: {
                protocolNotSupported = true;
            }
        }
        if (protocolNotSupported) {
            System.out.printf("protocol %s, not known or supported by enlinkd", this.protocol);
            return null;
        }
        if (protocolNotEnabled) {
            System.out.printf("protocol %s, not enabled in enlinkd config file", this.protocol);
            return null;
        }
        boolean run = this.reloadableTopologyDaemon.runSingleSnmpCollection(this.node, this.protocol);
        if (run) {
            System.out.printf("protocol %s, node %s found and collection has been runned and persisted", this.protocol, this.node);
        } else {
            System.out.printf("node %s not found or snmp not supported", this.node);
        }
        return null;
    }
}

