/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.profile.PlaceholderResolver;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.impl.PlaceholderResolvers;
import org.apache.karaf.profile.impl.Utils;

public final class Profiles {
    public static final String PROFILE_FOLDER_SUFFIX = ".profile";

    public static Map<String, Profile> loadProfiles(final Path root) throws IOException {
        final HashMap<String, Profile> profiles = new HashMap<String, Profile>();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            ProfileBuilder builder;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path fileName = dir.getFileName();
                if (fileName != null && (fileName.toString().endsWith(Profiles.PROFILE_FOLDER_SUFFIX) || fileName.toString().endsWith(".profile/"))) {
                    String profileId = root.relativize(dir).toString();
                    if (profileId.endsWith("/")) {
                        profileId = profileId.substring(0, profileId.length() - 1);
                    }
                    profileId = profileId.replace(root.getFileSystem().getSeparator(), "-");
                    profileId = profileId.substring(0, profileId.length() - Profiles.PROFILE_FOLDER_SUFFIX.length());
                    this.builder = ProfileBuilder.Factory.create(profileId);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                if (this.builder != null) {
                    Profile profile = this.builder.getProfile();
                    profiles.put(profile.getId(), profile);
                    this.builder = null;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (this.builder != null) {
                    String pid = file.getFileName().toString();
                    byte[] data = Files.readAllBytes(file);
                    this.builder.addFileConfiguration(pid, data);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return profiles;
    }

    public static void deleteProfile(Path root, String id) throws IOException {
        Path path = root.resolve(id.replace("-", root.getFileSystem().getSeparator()) + PROFILE_FOLDER_SUFFIX);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void writeProfile(Path root, Profile profile) throws IOException {
        Path path = root.resolve(profile.getId().replace("-", root.getFileSystem().getSeparator()) + PROFILE_FOLDER_SUFFIX);
        Files.createDirectories(path, new FileAttribute[0]);
        for (Map.Entry<String, byte[]> entry : profile.getFileConfigurations().entrySet()) {
            Files.write(path.resolve(entry.getKey()), entry.getValue(), StandardOpenOption.CREATE_NEW);
        }
    }

    public static Profile getOverlay(Profile profile, Map<String, Profile> profiles) {
        return Profiles.getOverlay(profile, profiles, null);
    }

    public static Profile getOverlay(Profile profile, Map<String, Profile> profiles, String environment) {
        Utils.assertNotNull(profile, "profile is null");
        Utils.assertNotNull(profile, "profiles is null");
        if (profile.isOverlay()) {
            return profile;
        }
        String profileId = profile.getId();
        ProfileBuilder builder = ProfileBuilder.Factory.create(profileId);
        new OverlayOptionsProvider(profiles, profile, environment).addOptions(builder);
        return builder.getProfile();
    }

    public static Profile getEffective(Profile profile) {
        return Profiles.getEffective(profile, true);
    }

    public static Profile getEffective(Profile profile, boolean finalSubstitution) {
        return Profiles.getEffective(profile, Collections.singleton(new PlaceholderResolvers.ProfilePlaceholderResolver()), finalSubstitution);
    }

    public static Profile getEffective(Profile profile, Collection<PlaceholderResolver> resolvers) {
        return Profiles.getEffective(profile, resolvers, true);
    }

    public static Profile getEffective(Profile profile, Collection<PlaceholderResolver> resolvers, boolean finalSubstitution) {
        Utils.assertNotNull(profile, "profile is null");
        Utils.assertNotNull(profile, "resolvers is null");
        HashMap<String, TypedProperties> originals = new HashMap<String, TypedProperties>();
        HashMap<String, TypedProperties> originals2 = new HashMap<String, TypedProperties>();
        for (Map.Entry<String, byte[]> entry : profile.getFileConfigurations().entrySet()) {
            if (!entry.getKey().endsWith(".cfg")) continue;
            try {
                String key2 = entry.getKey().substring(0, entry.getKey().length() - ".cfg".length());
                TypedProperties props = new TypedProperties(false);
                props.load(new ByteArrayInputStream(entry.getValue()));
                originals.put(key2, props);
                props = new TypedProperties(false);
                props.load(new ByteArrayInputStream(entry.getValue()));
                originals2.put(key2, props);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can not load properties for " + entry.getKey());
            }
        }
        Map<String, Map<String, String>> dynamic = TypedProperties.prepare(originals);
        TypedProperties.substitute(originals, dynamic, (pid, key, value) -> {
            if (value != null) {
                for (PlaceholderResolver resolver : resolvers) {
                    String val;
                    if (resolver.getScheme() != null || (val = resolver.resolve(dynamic, pid, key, value)) == null) continue;
                    return val;
                }
                if (value.contains(":")) {
                    String scheme = value.substring(0, value.indexOf(":"));
                    String toSubst = value.substring(scheme.length() + 1);
                    for (PlaceholderResolver resolver : resolvers) {
                        String val;
                        if (!scheme.equals(resolver.getScheme()) || (val = resolver.resolve(dynamic, pid, key, toSubst)) == null) continue;
                        return val;
                    }
                }
            }
            return null;
        }, finalSubstitution);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom(profile);
        for (String cfg : originals.keySet()) {
            TypedProperties original = (TypedProperties)originals.get(cfg);
            TypedProperties original2 = (TypedProperties)originals2.get(cfg);
            original2.putAll(original);
            builder.addFileConfiguration(cfg + ".cfg", Utils.toBytes(original2));
        }
        return builder.getProfile();
    }

    private Profiles() {
    }

    private static class OverlayOptionsProvider {
        private final Map<String, Profile> profiles;
        private final Profile self;
        private final String environment;

        private OverlayOptionsProvider(Map<String, Profile> profiles, Profile self, String environment) {
            this.profiles = profiles;
            this.self = self;
            this.environment = environment;
        }

        private ProfileBuilder addOptions(ProfileBuilder builder) {
            builder.setAttributes(this.self.getAttributes());
            builder.setFileConfigurations(this.getFileConfigurations());
            builder.setOverlay(true);
            return builder;
        }

        private Map<String, byte[]> getFileConfigurations() {
            HashMap<String, SupplementControl> aggregate = new HashMap<String, SupplementControl>();
            for (Profile profile : this.getInheritedProfiles()) {
                this.supplement(profile, aggregate);
            }
            HashMap<String, byte[]> rc = new HashMap<String, byte[]>();
            for (Map.Entry entry : aggregate.entrySet()) {
                SupplementControl ctrl = (SupplementControl)entry.getValue();
                if (ctrl.props != null) {
                    ctrl.data = Utils.toBytes(ctrl.props);
                }
                rc.put((String)entry.getKey(), ctrl.data);
            }
            return rc;
        }

        private List<Profile> getInheritedProfiles() {
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            this.fillParentProfiles(this.self, profiles);
            return profiles;
        }

        private void fillParentProfiles(Profile profile, List<Profile> profiles) {
            if (!profiles.contains(profile)) {
                for (String parentId : profile.getParentIds()) {
                    Profile parent = this.getRequiredProfile(parentId);
                    this.fillParentProfiles(parent, profiles);
                }
                profiles.add(profile);
            }
        }

        private void supplement(Profile profile, Map<String, SupplementControl> aggregate) {
            Map<String, byte[]> configs = profile.getFileConfigurations();
            for (String key : configs.keySet()) {
                SupplementControl ctrl;
                if (key.contains("#")) continue;
                byte[] value = configs.get(key);
                if (this.environment != null && configs.containsKey(key + "#" + this.environment)) {
                    value = configs.get(key + "#" + this.environment);
                }
                if (key.endsWith(".cfg")) {
                    ctrl = aggregate.get(key);
                    if (ctrl != null) {
                        TypedProperties childMap = Utils.toProperties(value);
                        if (childMap.remove("#deleted#") != null) {
                            ctrl.props.clear();
                        }
                        for (Map.Entry<String, Object> p : childMap.entrySet()) {
                            if ("#deleted#".equals(p.getValue())) {
                                ctrl.props.remove(p.getKey());
                                continue;
                            }
                            ctrl.props.put(p.getKey(), p.getValue());
                        }
                        continue;
                    }
                    ctrl = new SupplementControl();
                    ctrl.props = Utils.toProperties(value);
                    aggregate.put(key, ctrl);
                    continue;
                }
                ctrl = new SupplementControl();
                ctrl.data = value;
                aggregate.put(key, ctrl);
            }
        }

        private Profile getRequiredProfile(String id) {
            Profile profile = this.profiles.get(id);
            if (profile == null) {
                throw new IllegalStateException("Unable to find required profile " + id);
            }
            return profile;
        }

        private static class SupplementControl {
            byte[] data;
            TypedProperties props;

            private SupplementControl() {
            }
        }
    }
}

