/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.utils.resource.ResourceBuilder;
import org.apache.felix.utils.resource.ResourceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

public class FakeBundleRevision
extends ResourceImpl
implements BundleRevision,
BundleStartLevel {
    private final Bundle bundle;
    private int startLevel;

    public FakeBundleRevision(Hashtable<String, String> headers, String location, long bundleId) throws BundleException {
        ResourceBuilder.build(this, location, headers);
        this.bundle = (Bundle)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Bundle.class}, (InvocationHandler)new BundleRevisionInvocationHandler(headers, location, bundleId));
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public boolean isPersistentlyStarted() {
        return true;
    }

    public boolean isActivationPolicyUsed() {
        return false;
    }

    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    public Version getVersion() {
        return this.bundle.getVersion();
    }

    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        throw new UnsupportedOperationException();
    }

    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        throw new UnsupportedOperationException();
    }

    public int getTypes() {
        throw new UnsupportedOperationException();
    }

    public BundleWiring getWiring() {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    private class BundleRevisionInvocationHandler
    implements InvocationHandler {
        private final Hashtable<String, String> headers;
        private final String location;
        private final long bundleId;

        public BundleRevisionInvocationHandler(Hashtable<String, String> headers, String location, long bundleId) {
            this.headers = headers;
            this.location = location;
            this.bundleId = bundleId;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "hashCode": {
                    return FakeBundleRevision.this.hashCode();
                }
                case "equals": {
                    return proxy == args[0];
                }
                case "toString": {
                    return FakeBundleRevision.this.bundle.getSymbolicName() + "/" + FakeBundleRevision.this.bundle.getVersion();
                }
                case "adapt": {
                    if (args.length == 1 && args[0] == BundleRevision.class) {
                        return FakeBundleRevision.this;
                    }
                    if (args.length != 1 || args[0] != BundleStartLevel.class) break;
                    return FakeBundleRevision.this;
                }
                case "getHeaders": {
                    return this.headers;
                }
                case "getBundleId": {
                    return this.bundleId;
                }
                case "getLocation": {
                    return this.location;
                }
                case "getSymbolicName": {
                    String name = this.headers.get("Bundle-SymbolicName");
                    int idx = name.indexOf(59);
                    if (idx > 0) {
                        name = name.substring(0, idx).trim();
                    }
                    return name;
                }
                case "getVersion": {
                    return new Version(this.headers.get("Bundle-Version"));
                }
                case "getState": {
                    return 32;
                }
                case "getLastModified": {
                    return 0L;
                }
            }
            return null;
        }
    }
}

