/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.karaf.deployer.blueprint.BlueprintTransformer;
import org.apache.karaf.deployer.spring.SpringTransformer;
import org.apache.karaf.features.internal.download.impl.AbstractRetryableDownloadTask;
import org.apache.karaf.profile.Profile;
import org.ops4j.pax.url.war.Handler;

public class CustomSimpleDownloadTask
extends AbstractRetryableDownloadTask {
    private static final String WRAP_URI_PREFIX = "wrap";
    private static final String SPRING_URI_PREFIX = "spring";
    private static final String BLUEPRINT_URI_PREFIX = "blueprint";
    private static final String WAR_URI_PREFIX = "war";
    private static final String PROFILE_URI_PREFIX = "profile";
    private final Profile profile;

    public CustomSimpleDownloadTask(ScheduledExecutorService executorService, Profile profile, String url) {
        super(executorService, url);
        this.profile = profile;
    }

    protected File download(Exception previousExceptionNotUsed) throws Exception {
        URL url = this.createUrl(this.getUrl());
        Path path = Files.createTempFile("download-", null, new FileAttribute[0]);
        try (InputStream is = url.openStream();){
            Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
        }
        return path.toFile();
    }

    private URL createUrl(String url) throws MalformedURLException, URISyntaxException {
        URLStreamHandler handler = this.getUrlStreamHandler(url);
        if (handler != null) {
            return new URL(null, url, handler);
        }
        return new URL(url);
    }

    private URLStreamHandler getUrlStreamHandler(String url) throws URISyntaxException {
        String scheme;
        if (url.contains("\\")) {
            url = url.replace("\\", "/");
        }
        switch (scheme = url.substring(0, url.indexOf(58))) {
            case "wrap": {
                return new org.ops4j.pax.url.wrap.Handler();
            }
            case "war": {
                return new Handler();
            }
            case "spring": {
                return new SpringURLHandler();
            }
            case "blueprint": {
                return new BlueprintURLHandler();
            }
            case "profile": {
                if (this.profile == null) break;
                return new ProfileURLHandler();
            }
        }
        return null;
    }

    public class ProfileURLHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    String path = this.url.getPath();
                    byte[] data = CustomSimpleDownloadTask.this.profile.getFileConfiguration(path);
                    if (data == null) {
                        throw new FileNotFoundException(this.url.toExternalForm());
                    }
                    return new ByteArrayInputStream(data);
                }
            };
        }
    }

    public class BlueprintURLHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        BlueprintTransformer.transform((URL)CustomSimpleDownloadTask.this.createUrl(this.url.getPath()), (OutputStream)os);
                        os.close();
                        return new ByteArrayInputStream(os.toByteArray());
                    }
                    catch (Exception e) {
                        throw new IOException("Error opening blueprint xml url", e);
                    }
                }
            };
        }
    }

    public class SpringURLHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        SpringTransformer.transform((URL)CustomSimpleDownloadTask.this.createUrl(this.url.getPath()), (OutputStream)os);
                        os.close();
                        return new ByteArrayInputStream(os.toByteArray());
                    }
                    catch (Exception e) {
                        throw new IOException("Error opening spring xml url", e);
                    }
                }
            };
        }
    }
}

