/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.Archive;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

class RrdInfoCmd
extends RrdToolCmd {
    RrdInfoCmd() {
    }

    @Override
    String getCmdType() {
        return "info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object execute() throws RrdException, IOException {
        String info;
        String[] words = this.getRemainingWords();
        if (words.length != 2) {
            throw new RrdException("Invalid rrdinfo syntax");
        }
        String path = words[1];
        RrdDb rrd = RrdInfoCmd.getRrdDbReference(path);
        try {
            info = this.getInfo(rrd);
            RrdInfoCmd.println(info);
        }
        finally {
            RrdInfoCmd.releaseRrdDbReference(rrd);
        }
        return info;
    }

    private String getInfo(RrdDb rrd) throws IOException {
        int i;
        StringBuffer b = new StringBuffer();
        b.append("filename = \"").append(rrd.getPath()).append("\"\n");
        b.append("rrd_version = \"0001\"\n");
        b.append("step = ").append(rrd.getHeader().getStep()).append("\n");
        b.append("last_update = ").append(rrd.getHeader().getLastUpdateTime()).append("\n");
        for (i = 0; i < rrd.getDsCount(); ++i) {
            Datasource ds = rrd.getDatasource(i);
            b.append("ds[").append(ds.getDsName()).append("].type = \"").append(ds.getDsType()).append("\"\n");
            b.append("ds[").append(ds.getDsName()).append("].minimal_heartbeat = ").append(ds.getHeartbeat()).append("\n");
            b.append("ds[").append(ds.getDsName()).append("].min = ").append(ds.getMinValue()).append("\n");
            b.append("ds[").append(ds.getDsName()).append("].max = ").append(ds.getMaxValue()).append("\n");
            b.append("ds[").append(ds.getDsName()).append("].last_ds = ").append(ds.getLastValue()).append("\n");
            b.append("ds[").append(ds.getDsName()).append("].value = ").append(ds.getAccumValue()).append("\n");
            b.append("ds[").append(ds.getDsName()).append("].unknown_sec = ").append(ds.getNanSeconds()).append("\n");
        }
        for (i = 0; i < rrd.getArcCount(); ++i) {
            Archive arc = rrd.getArchive(i);
            b.append("rra[").append(i).append("].cf = \"").append(arc.getConsolFun()).append("\"\n");
            b.append("rra[").append(i).append("].rows = ").append(arc.getRows()).append("\n");
            b.append("rra[").append(i).append("].pdp_per_row = ").append(arc.getSteps()).append("\n");
            b.append("rra[").append(i).append("].xff = ").append(arc.getXff()).append("\n");
            for (int j = 0; j < rrd.getDsCount(); ++j) {
                b.append("rra[").append(i).append("].cdp_prep[").append(j).append("].value = ").append(arc.getArcState(j).getAccumValue()).append("\n");
                b.append("rra[").append(i).append("].cdp_prep[").append(j).append("].unknown_datapoints = ").append(arc.getArcState(j).getNanSteps()).append("\n");
            }
        }
        return b.toString();
    }
}

