/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.context;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SAMLContextProviderLB
extends SAMLContextProviderImpl {
    private String scheme;
    private String serverName;
    private boolean includeServerPortInRequestURL;
    private int serverPort;
    private String contextPath;

    @Override
    protected void populateGenericContext(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext context) throws MetadataProviderException {
        super.populateGenericContext((HttpServletRequest)new LPRequestWrapper(request), response, context);
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setIncludeServerPortInRequestURL(boolean includeServerPortInRequestURL) {
        this.includeServerPortInRequestURL = includeServerPortInRequestURL;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null || "/".equals(contextPath)) {
            contextPath = "";
        }
        this.contextPath = contextPath;
    }

    @Override
    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.hasText((String)this.scheme, (String)"Scheme must be set");
        Assert.hasText((String)this.serverName, (String)"Server name must be set");
        Assert.notNull((Object)this.contextPath, (String)"Context path must be set");
        if (StringUtils.hasLength((String)this.contextPath)) {
            Assert.isTrue((boolean)this.contextPath.startsWith("/"), (String)"Context path must be set and start with a forward slash");
        }
    }

    private class LPRequestWrapper
    extends HttpServletRequestWrapper {
        private LPRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getContextPath() {
            return SAMLContextProviderLB.this.contextPath;
        }

        public String getScheme() {
            return SAMLContextProviderLB.this.scheme;
        }

        public String getServerName() {
            return SAMLContextProviderLB.this.serverName;
        }

        public int getServerPort() {
            return SAMLContextProviderLB.this.serverPort;
        }

        public String getRequestURI() {
            StringBuilder sb = new StringBuilder(SAMLContextProviderLB.this.contextPath);
            sb.append(this.getServletPath());
            return sb.toString();
        }

        public StringBuffer getRequestURL() {
            StringBuffer sb = new StringBuffer();
            sb.append(SAMLContextProviderLB.this.scheme).append("://").append(SAMLContextProviderLB.this.serverName);
            if (SAMLContextProviderLB.this.includeServerPortInRequestURL) {
                sb.append(":").append(SAMLContextProviderLB.this.serverPort);
            }
            sb.append(SAMLContextProviderLB.this.contextPath);
            sb.append(this.getServletPath());
            if (this.getPathInfo() != null) {
                sb.append(this.getPathInfo());
            }
            return sb;
        }

        public boolean isSecure() {
            return "https".equalsIgnoreCase(SAMLContextProviderLB.this.scheme);
        }
    }
}

