/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.liberty.binding.decoding;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPSOAP11Decoder;
import org.opensaml.saml2.ecp.impl.RelayStateImpl;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xml.parse.ParserPool;

public class HTTPPAOS11Decoder
extends HTTPSOAP11Decoder {
    public HTTPPAOS11Decoder() {
        this.initUnderstoodHeaders();
    }

    public HTTPPAOS11Decoder(ParserPool pool) {
        super(pool);
        this.initUnderstoodHeaders();
    }

    private void initUnderstoodHeaders() {
        QName paosResponse = new QName("urn:liberty:paos:2003-08", "Response", "paos");
        ArrayList<QName> headerNames = new ArrayList<QName>();
        headerNames.add(paosResponse);
        this.setUnderstoodHeaders(headerNames);
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        super.doDecode(messageContext);
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Envelope soapMessage = (Envelope)samlMsgCtx.getInboundMessage();
        List relayStateHeader = soapMessage.getHeader().getUnknownXMLObjects(new QName("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp", "RelayState", "ecp"));
        if (relayStateHeader.size() == 1 && relayStateHeader.get(0) instanceof RelayStateImpl) {
            samlMsgCtx.setRelayState(((RelayStateImpl)relayStateHeader.get(0)).getValue());
        }
    }
}

