/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.common;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.scheduler.Schedulable;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyMessage;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyRef;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyUpdater;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TopologyUpdater
extends Schedulable
implements OnmsTopologyUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyUpdater.class);
    private final OnmsTopologyDao m_topologyDao;
    private final NodeTopologyService m_nodeTopologyService;
    private final TopologyService m_topologyService;
    private final Object m_lock = new Object();
    private OnmsTopology m_topology;
    private boolean m_runned = false;
    private boolean m_registered = false;
    private boolean m_forceRun = false;

    public static OnmsTopologyProtocol create(ProtocolSupported protocol) {
        return OnmsTopologyProtocol.create((String)protocol.name());
    }

    public static OnmsTopologyVertex create(NodeTopologyEntity node, IpInterfaceTopologyEntity primary) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(node.getId());
        OnmsTopologyVertex vertex = OnmsTopologyVertex.create((String)node.getId().toString(), (String)node.getLabel(), (String)Topology.getAddress((IpInterfaceTopologyEntity)primary), (String)Topology.getIconKey((NodeTopologyEntity)node));
        vertex.setNodeid(node.getId());
        vertex.setToolTipText(Topology.getNodeTextString((NodeTopologyEntity)node, (IpInterfaceTopologyEntity)primary));
        return vertex;
    }

    public TopologyUpdater(TopologyService topologyService, OnmsTopologyDao topologyDao, NodeTopologyService nodeTopologyService) {
        this.m_topologyDao = topologyDao;
        this.m_topologyService = topologyService;
        this.m_nodeTopologyService = nodeTopologyService;
        this.m_topology = new OnmsTopology();
    }

    public void register() {
        if (this.m_registered) {
            return;
        }
        try {
            this.m_topologyDao.register((OnmsTopologyUpdater)this);
            this.m_registered = true;
            LOG.info("register: protocol:{}", (Object)this.getProtocol().getId());
        }
        catch (Exception e) {
            LOG.error("register", (Throwable)e);
        }
    }

    public void unregister() {
        if (!this.m_registered) {
            return;
        }
        try {
            this.m_topologyDao.unregister((OnmsTopologyUpdater)this);
            this.m_registered = false;
            LOG.info("unregister: protocol:{}", (Object)this.getProtocol().getId());
        }
        catch (Exception e) {
            LOG.error("unregister", (Throwable)e);
        }
    }

    private <T extends OnmsTopologyRef> void update(T topoObject) {
        try {
            this.m_topologyDao.update((OnmsTopologyUpdater)this, OnmsTopologyMessage.update(topoObject, (OnmsTopologyProtocol)this.getProtocol()));
        }
        catch (Exception e) {
            LOG.error("Exception while updating", (Throwable)e);
        }
    }

    private <T extends OnmsTopologyRef> void delete(T topoObject) {
        try {
            this.m_topologyDao.update((OnmsTopologyUpdater)this, OnmsTopologyMessage.delete(topoObject, (OnmsTopologyProtocol)this.getProtocol()));
        }
        catch (Exception e) {
            LOG.error("Exception while deleting", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runSchedulable() {
        LOG.info("run: start {}", (Object)this.getName());
        OnmsTopology oldTopology = this.m_topology.clone();
        OnmsTopology newTopology = this.runDiscoveryInternally(oldTopology);
        if (oldTopology != newTopology) {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_topology = newTopology;
                this.setDefaultVertex();
            }
        }
        LOG.info("run: end {}", (Object)this.getName());
    }

    public void setDefaultVertex() {
        if (this.m_topology.getVertices().isEmpty()) {
            LOG.info("setDefaultVertex: {}: topology is empty", (Object)this.getName());
            return;
        }
        NodeTopologyEntity defaultFocusPoint = this.getDefaultFocusPoint();
        if (defaultFocusPoint != null) {
            OnmsTopologyVertex dv = TopologyUpdater.create(defaultFocusPoint, this.getIpPrimaryMap().get(defaultFocusPoint.getId()));
            if (this.m_topology.hasVertex(dv.getId())) {
                this.m_topology.setDefaultVertex(dv);
                LOG.info("setDefaultVertex: {}: set default: {}", (Object)this.getName(), (Object)dv.getLabel());
            } else {
                this.m_topology.setDefaultVertex((OnmsTopologyVertex)this.m_topology.getVertices().iterator().next());
                LOG.info("setDefaultVertex: {}: set first item: {}", (Object)this.getName(), (Object)this.m_topology.getDefaultVertex().getLabel());
            }
        }
    }

    protected OnmsTopology runDiscoveryInternally(OnmsTopology oldTopology) {
        if (!this.m_runned) {
            try {
                OnmsTopology newTopology = this.buildTopology();
                this.m_runned = true;
                this.m_topologyService.parseUpdates();
                newTopology.getVertices().forEach(this::update);
                newTopology.getEdges().forEach(this::update);
                LOG.info("run: {} first run topology calculated", (Object)this.getName());
                return newTopology;
            }
            catch (Exception e) {
                LOG.error("run: {} first run: cannot build topology", (Object)this.getName(), (Object)e);
                return oldTopology;
            }
        }
        if (this.m_topologyService.parseUpdates() || this.m_forceRun) {
            OnmsTopology newTopology;
            this.m_forceRun = false;
            this.m_topologyService.refresh();
            LOG.info("run: updates {}, recalculating topology ", (Object)this.getName());
            try {
                newTopology = this.buildTopology();
            }
            catch (Exception e) {
                LOG.error("cannot build topology", (Throwable)e);
                return oldTopology;
            }
            oldTopology.getVertices().stream().filter(v -> !newTopology.hasVertex(v.getId())).forEach(this::delete);
            oldTopology.getEdges().stream().filter(g -> !newTopology.hasEdge(g.getId())).forEach(this::delete);
            newTopology.getVertices().stream().filter(v -> !this.m_topology.hasVertex(v.getId())).forEach(this::update);
            newTopology.getEdges().stream().filter(g -> !this.m_topology.hasEdge(g.getId())).forEach(this::update);
            return newTopology;
        }
        return oldTopology;
    }

    public OnmsTopologyDao getTopologyDao() {
        return this.m_topologyDao;
    }

    public NodeTopologyService getNodeTopologyService() {
        return this.m_nodeTopologyService;
    }

    public Map<Integer, NodeTopologyEntity> getNodeMap() {
        return this.m_nodeTopologyService.findAllNode().stream().collect(Collectors.toMap(NodeTopologyEntity::getId, node -> node, (n1, n2) -> n1));
    }

    public Map<Integer, IpInterfaceTopologyEntity> getIpPrimaryMap() {
        return this.m_nodeTopologyService.findAllIp().stream().collect(Collectors.toMap(IpInterfaceTopologyEntity::getNodeId, ip -> ip, TopologyUpdater::getPrimary));
    }

    public Table<Integer, Integer, SnmpInterfaceTopologyEntity> getSnmpInterfaceTable() {
        HashBasedTable nodeToOnmsSnmpTable = HashBasedTable.create();
        for (SnmpInterfaceTopologyEntity snmp : this.m_nodeTopologyService.findAllSnmp()) {
            if (nodeToOnmsSnmpTable.contains((Object)snmp.getNodeId(), (Object)snmp.getIfIndex())) continue;
            nodeToOnmsSnmpTable.put((Object)snmp.getNodeId(), (Object)snmp.getIfIndex(), (Object)snmp);
        }
        return nodeToOnmsSnmpTable;
    }

    public Map<Integer, SnmpInterfaceTopologyEntity> getSnmpInterfaceMap() {
        return this.m_nodeTopologyService.findAllSnmp().stream().collect(Collectors.toMap(SnmpInterfaceTopologyEntity::getId, Function.identity()));
    }

    public Table<Integer, InetAddress, IpInterfaceTopologyEntity> getIpInterfaceTable() {
        HashBasedTable nodeToOnmsIpTable = HashBasedTable.create();
        for (IpInterfaceTopologyEntity ip : this.m_nodeTopologyService.findAllIp()) {
            if (nodeToOnmsIpTable.contains((Object)ip.getNodeId(), (Object)ip.getIpAddress())) continue;
            nodeToOnmsIpTable.put((Object)ip.getNodeId(), (Object)ip.getIpAddress(), (Object)ip);
        }
        return nodeToOnmsIpTable;
    }

    private static IpInterfaceTopologyEntity getPrimary(IpInterfaceTopologyEntity n1, IpInterfaceTopologyEntity n2) {
        if (PrimaryType.PRIMARY.equals((Object)n2.getIsSnmpPrimary())) {
            return n2;
        }
        return n1;
    }

    public abstract OnmsTopology buildTopology();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnmsTopology getTopology() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_topology.clone();
        }
    }

    public NodeTopologyEntity getDefaultFocusPoint() {
        return this.m_nodeTopologyService.getDefaultFocusPoint();
    }

    public boolean isRegistered() {
        return this.m_registered;
    }

    public void setRegistered(boolean registered) {
        this.m_registered = registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopology(OnmsTopology topology) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_topology = topology;
        }
    }

    public boolean isRunned() {
        return this.m_runned;
    }

    public void setRunned(boolean runned) {
        this.m_runned = runned;
    }

    public void forceRun() {
        this.m_forceRun = true;
    }
}

