/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.persistence.api;

import com.google.common.base.Strings;
import java.util.Objects;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.Protocol;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;

public class RuleBuilder {
    private Rule rule = new Rule();

    public RuleBuilder withName(String name) {
        this.rule.setName(name);
        return this;
    }

    public RuleBuilder withDstAddress(String dstAddress) {
        this.rule.setDstAddress(dstAddress);
        return this;
    }

    public RuleBuilder withDstPort(String dstPort) {
        this.rule.setDstPort(dstPort);
        return this;
    }

    public RuleBuilder withDstPort(int dstPort) {
        this.rule.setDstPort("" + dstPort);
        return this;
    }

    public RuleBuilder withSrcAddress(String srcAddress) {
        this.rule.setSrcAddress(srcAddress);
        return this;
    }

    public RuleBuilder withSrcPort(String srcPort) {
        this.rule.setSrcPort(srcPort);
        return this;
    }

    public RuleBuilder withSrcPort(int srcPort) {
        this.rule.setSrcPort("" + srcPort);
        return this;
    }

    public RuleBuilder withProtocol(String protocol) {
        this.rule.setProtocol(protocol);
        return this;
    }

    public RuleBuilder withProtocol(Protocol protocol) {
        this.rule.setProtocol(protocol.getKeyword());
        return this;
    }

    public RuleBuilder withOmnidirectional(boolean omnidirectional) {
        this.rule.setOmnidirectional(omnidirectional);
        return this;
    }

    public RuleBuilder withExporterFilter(String exporterFilter) {
        this.rule.setExporterFilter(exporterFilter);
        return this;
    }

    public RuleBuilder withGroup(Group group) {
        group.addRule(this.rule);
        return this;
    }

    public RuleBuilder fromRule(Rule rule) {
        Objects.requireNonNull(rule);
        this.withName(rule.getName());
        this.withSrcAddress(rule.getSrcAddress());
        this.withSrcPort(rule.getSrcPort());
        this.withDstAddress(rule.getDstAddress());
        this.withDstPort(rule.getDstPort());
        this.withProtocol(rule.getProtocol());
        this.withOmnidirectional(rule.isOmnidirectional());
        this.withExporterFilter(rule.getExporterFilter());
        if (rule.getGroup() != null) {
            this.withGroup(rule.getGroup());
        }
        return this;
    }

    public RuleBuilder withPosition(int position) {
        this.rule.setPosition(position);
        return this;
    }

    public Rule build() {
        if (Strings.isNullOrEmpty((String)this.rule.getName())) {
            throw new IllegalStateException("Cannot build rule. Field 'name' must not be null or empty.");
        }
        return this.rule;
    }
}

