/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.util.HashMap;
import java.util.Map;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.opennms.systemreport.event.CsvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class UserLoginsReportPlugin
extends AbstractSystemReportPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(UserLoginsReportPlugin.class);

    @Override
    public String getName() {
        return "User Logins";
    }

    @Override
    public String getDescription() {
        return "User Logins during past 60 days";
    }

    @Override
    public int getPriority() {
        return 7;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String defaultFormat() {
        return ".csv";
    }

    @Override
    public Map<String, Resource> getEntries() {
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        try {
            Resource csvHeaders = CsvUtils.readCsvHeaders(CsvUtils.USER_LOGINS_CSV_FILE_PATH);
            Resource csvData = CsvUtils.readCsvData(CsvUtils.USER_LOGINS_CSV_FILE_PATH, Boolean.TRUE);
            map.put("csvHeaders", csvHeaders);
            map.put("csvData", csvData);
        }
        catch (Exception e) {
            LOG.error("Unable to create temporary file!", (Throwable)e);
        }
        return map;
    }
}

