/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.core.io.Resource;
import oshi.SystemInfo;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.FileSystem;
import oshi.software.os.OperatingSystem;

public class HardDriveReportPlugin
extends AbstractSystemReportPlugin {
    @Override
    public String getName() {
        return "Hard Drive Stats";
    }

    @Override
    public String getDescription() {
        return "Hard Drive Capacity and Performance Information";
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public Map<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        map.put("Hard Drive Capacity", this.getResource("\n" + this.getDiskCapacityInfo()));
        map.put("Hard Drive Performance", this.getResource("\n" + this.getDiskPerformanceInfo()));
        return map;
    }

    private String getDiskPerformanceInfo() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hal = systemInfo.getHardware();
        HWDiskStore[] diskStores = hal.getDiskStores().toArray(new HWDiskStore[0]);
        String header = String.format("%-20s %-10s %-10s %-10s %-15s %-15s%n", "Disk", "Size", "Reads", "Writes", "Read Bytes", "Write Bytes");
        String diskInfo = Arrays.stream(diskStores).map(disk -> String.format("%-20s %-10s %-10s %-10s %-15s %-15s%n", disk.getName(), this.formatDiskSize(disk.getSize()), this.formatDiskSize(disk.getReads()), this.formatDiskSize(disk.getWrites()), this.formatDiskSize(disk.getReadBytes()), this.formatDiskSize(disk.getWriteBytes()))).collect(Collectors.joining());
        return header + diskInfo;
    }

    private String getDiskCapacityInfo() {
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem os = systemInfo.getOperatingSystem();
        FileSystem fileSystem = os.getFileSystem();
        String headers = String.format("%-20s %-10s %-10s %-10s %-10s %-10s%n", "Filesystem", "Size", "Used", "Avail", "Use%", "Mounted on");
        String fileStoresInfo = fileSystem.getFileStores().stream().map(fs -> {
            long total = fs.getTotalSpace();
            long free = fs.getUsableSpace();
            long used = total - free;
            double percentUsed = total > 0L ? 100.0 * (double)used / (double)total : 0.0;
            return String.format("%-20s %-10s %-10s %-10s %-10s %-10s%n", fs.getName(), this.formatDiskSize(total), this.formatDiskSize(used), this.formatDiskSize(free), String.format("%.1f%%", percentUsed), fs.getMount());
        }).collect(Collectors.joining());
        return headers + fileStoresInfo;
    }

    private String formatDiskSize(long bytes) {
        return FileUtils.byteCountToDisplaySize((long)bytes);
    }
}

