/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FullTextSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(FullTextSystemReportFormatter.class);

    @Override
    public String getName() {
        return "full";
    }

    @Override
    public String getDescription() {
        return "Human-readable text (full output)";
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getExtension() {
        return "txt";
    }

    @Override
    public boolean canStdout() {
        return true;
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        OutputStream out = this.getOutputStream();
        try {
            out.write(String.format("= %s: %s =%n%n", plugin.getName(), plugin.getDescription()).getBytes());
            for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
                int bytes;
                Resource value = entry.getValue();
                out.write(String.format("== %s ==%n%n", entry.getKey()).getBytes());
                InputStream is = value.getInputStream();
                byte[] buffer = new byte[1024];
                while ((bytes = is.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes);
                }
                is.close();
                out.write(String.format("%n%n", new Object[0]).getBytes());
            }
        }
        catch (Exception e) {
            LOG.info("unable to write", (Throwable)e);
        }
    }
}

