/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.commands;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.features.jmxconfiggenerator.commands.CmdRunException;
import org.opennms.features.jmxconfiggenerator.commands.JmxCommand;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxDatacollectionConfiggenerator;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxHelper;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQueryException;
import org.opennms.features.jmxconfiggenerator.log.ConsoleLogAdapter;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;

public class JmxConfigCreateCommand
extends JmxCommand {
    private final LogAdapter LOG = new ConsoleLogAdapter();
    @Option(name="--service", usage="your optional service-name. Like cassandra, jboss, tomcat")
    private String serviceName = "anyservice";
    @Option(name="--skipDefaultVM", usage="set to process default JavaVM Beans.")
    private boolean skipDefaultVM = false;
    @Option(name="--skipNonNumber", usage="do not process any non-number values.")
    private boolean skipNonNumber = false;
    @Option(name="--output", usage="file name to write generated jmx-datacollection-config.xml", required=false, metaVar="<file>")
    private String outFile;
    @Option(name="--dictionary", usage="dictionary properties file for replacing attribute names and parts of this names", metaVar="<file>")
    private String dictionaryFile;
    @Option(name="--print-dictionary", usage="prints the used dictionary to the cmd line. May be used with --dictionary")
    private boolean showDictionary;
    @Argument(usage="a list of attribute ids to to include for the generation.", metaVar="<attribute id>", required=false)
    private List<String> ids;

    @Override
    protected void validate(CmdLineParser parser) throws CmdLineException {
        if (this.showDictionary) {
            return;
        }
        super.validate(parser);
        if (this.outFile == null) {
            throw new CmdLineException("You must specify --output <file>. See --help for more details.");
        }
        if (this.ids == null) {
            throw new CmdLineException("You must specify at least one <attribute id>. See --help for more details.");
        }
    }

    @Override
    protected void execute() throws CmdLineException, CmdRunException {
        if (this.showDictionary) {
            this.printDictionary();
            return;
        }
        super.execute();
    }

    @Override
    protected void execute(MBeanServerConnection mbeanServerConnection) throws IOException, MBeanServerQueryException, JMException {
        JmxDatacollectionConfiggenerator jmxConfigGenerator = new JmxDatacollectionConfiggenerator(this.LOG);
        Map<String, String> dictionary = this.loadDictionary();
        JmxDatacollectionConfig generateJmxConfigModel = jmxConfigGenerator.generateJmxConfigModel(this.ids, mbeanServerConnection, this.serviceName, !this.skipDefaultVM, this.skipNonNumber, dictionary);
        jmxConfigGenerator.writeJmxConfigFile(generateJmxConfigModel, this.outFile);
    }

    private void printDictionary() {
        try {
            Map<String, String> dictionary = this.loadDictionary();
            if (this.dictionaryFile != null) {
                this.LOG.info("Custom dictionary file '{}':", this.dictionaryFile);
            } else {
                this.LOG.info("Internal dictionary file:", new Object[0]);
            }
            for (Map.Entry<String, String> eachEntry : dictionary.entrySet()) {
                this.LOG.info("{} = {}", eachEntry.getKey(), eachEntry.getValue());
            }
        }
        catch (IOException ioEx) {
            new CmdRunException(ioEx);
        }
    }

    private Map<String, String> loadDictionary() throws IOException {
        if (this.dictionaryFile != null) {
            this.LOG.debug("Custom dictionary file '{}' defined. Loading...", this.dictionaryFile);
            return this.loadExternalDictionary(this.dictionaryFile);
        }
        this.LOG.debug("No dictionary file defined. Using internal dictionary...", new Object[0]);
        return this.loadInternalDictionary();
    }

    @Override
    protected String getDescription() {
        return "Creates the jmxconfiguration.xml file with the given attribute ids.";
    }

    private Map<String, String> loadInternalDictionary() throws IOException {
        Map<String, String> internalDictionary = JmxHelper.loadInternalDictionary();
        this.LOG.info("Dictionary entries loaded: '{}'", internalDictionary.size());
        return internalDictionary;
    }

    private Map<String, String> loadExternalDictionary(String dictionaryFile) throws IOException {
        HashMap<String, String> externalDictionary = new HashMap<String, String>();
        Properties properties = new Properties();
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(dictionaryFile));){
            properties.load(stream);
        }
        this.LOG.info("Loaded '{}' external dictionary entries from '{}'", properties.size(), dictionaryFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            externalDictionary.put(key.toString(), value == null ? null : value.toString());
        }
        this.LOG.info("Dictionary entries loaded: '{}'", externalDictionary.size());
        return externalDictionary;
    }
}

