/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.dns;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.AbstractRequisitionProvider;
import org.opennms.netmgt.provision.persist.RequisitionRequest;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.service.dns.DnsRequisitionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class DnsRequisitionProvider
extends AbstractRequisitionProvider<DnsRequisitionRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DnsRequisitionProvider.class);
    public static final String TYPE_NAME = "dns";

    public DnsRequisitionProvider() {
        super(DnsRequisitionRequest.class);
    }

    public String getType() {
        return TYPE_NAME;
    }

    public RequisitionRequest getRequest(Map<String, String> parameters) {
        return new DnsRequisitionRequest(parameters);
    }

    public Requisition getRequisitionFor(DnsRequisitionRequest request) {
        ZoneTransferIn xfer = null;
        final LinkedHashSet records = new LinkedHashSet();
        ZoneTransferIn.ZoneTransferHandler handler = new ZoneTransferIn.ZoneTransferHandler(){

            public void startAXFR() throws ZoneTransferException {
            }

            public void startIXFR() throws ZoneTransferException {
            }

            public void startIXFRDeletes(Record soa) throws ZoneTransferException {
            }

            public void startIXFRAdds(Record soa) throws ZoneTransferException {
            }

            public void handleRecord(Record r) throws ZoneTransferException {
                records.add(r);
            }
        };
        LOG.debug("connecting to host {}:{}", (Object)request.getHost(), (Object)request.getPort());
        try {
            try {
                xfer = ZoneTransferIn.newIXFR((Name)new Name(request.getZone()), (long)request.getSerial(), (boolean)request.getFallback(), (String)request.getHost(), (int)request.getPort(), null);
                xfer.run(handler);
            }
            catch (ZoneTransferException e) {
                String message = "IXFR not supported trying AXFR: " + String.valueOf((Object)e);
                LOG.warn(message, (Throwable)e);
                xfer = ZoneTransferIn.newAXFR((Name)new Name(request.getZone()), (String)request.getHost(), null);
                xfer.run(handler);
            }
        }
        catch (IOException | ZoneTransferException e) {
            throw new RuntimeException(e);
        }
        LOG.debug("records={}", records);
        if (!records.isEmpty()) {
            Requisition r = new Requisition(request.getForeignSource());
            for (Record rec : records) {
                if (!this.matchingRecord(request, rec)) continue;
                r.insertNode(this.createRequisitionNode(request, rec));
            }
            return r;
        }
        return null;
    }

    private boolean matchingRecord(DnsRequisitionRequest request, Record rec) {
        LOG.info("matchingRecord: checking rec: {} to see if it should be imported...", (Object)rec);
        boolean matches = false;
        String stringType = Type.string((int)rec.getType());
        if ("A".equals(stringType) || "AAAA".equals(stringType)) {
            LOG.debug("matchingRecord: record is an {} record, continuing...", (Object)stringType);
            String expression = request.getExpression();
            if (expression != null) {
                Pattern p = Pattern.compile(expression);
                Matcher m = p.matcher(rec.getName().toString());
                LOG.debug("matchingRecord: attempting to match hostname: [{}] with expression: [ {} ]", (Object)rec.getName(), (Object)expression);
                if (m.matches()) {
                    matches = true;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("matchingRecord: attempting to match record: [{} {}] with expression: [{}]", new Object[]{rec.getName(), rec.rdataToString(), expression});
                    }
                    if ((m = p.matcher(rec.getName().toString() + " " + rec.rdataToString())).matches()) {
                        matches = true;
                    }
                }
                LOG.debug("matchingRecord: record matches expression: {}", (Object)matches);
            } else {
                LOG.debug("matchingRecord: no expression for this zone, returning valid match for this {} record...", (Object)stringType);
                matches = true;
            }
        }
        LOG.info("matchingRecord: record: {} matches: {}", (Object)matches, (Object)rec);
        return matches;
    }

    private RequisitionNode createRequisitionNode(DnsRequisitionRequest request, Record rec) {
        String addr = null;
        if ("A".equals(Type.string((int)rec.getType()))) {
            ARecord arec = (ARecord)rec;
            addr = InetAddressUtils.str((InetAddress)arec.getAddress());
        } else if ("AAAA".equals(Type.string((int)rec.getType()))) {
            AAAARecord aaaarec = (AAAARecord)rec;
            addr = InetAddressUtils.str((InetAddress)aaaarec.getAddress());
        } else {
            throw new IllegalArgumentException("Invalid record type " + Type.string((int)rec.getType()) + ". A or AAAA expected.");
        }
        RequisitionNode n = new RequisitionNode();
        String host = rec.getName().toString();
        String nodeLabel = StringUtils.stripEnd((String)StringUtils.stripStart((String)host, (String)"."), (String)".");
        n.setBuilding(request.getForeignSource());
        if (!Strings.isNullOrEmpty((String)request.getLocation())) {
            if (request.getLocation().startsWith("~")) {
                String match;
                Pattern pattern = Pattern.compile(request.getLocation().substring(1));
                Matcher matcher = pattern.matcher(host);
                if (matcher.groupCount() != 1) {
                    LOG.error("The pattern '{}' may contain only one capturing group.", (Object)pattern);
                } else if (matcher.find() && !Strings.isNullOrEmpty((String)(match = matcher.group(1)))) {
                    n.setLocation(match);
                    LOG.debug("Node '{}' location set to {}", (Object)n.getNodeLabel(), (Object)n.getLocation());
                }
            } else {
                n.setLocation(request.getLocation());
                LOG.debug("Node '{}' location set to {}", (Object)n.getNodeLabel(), (Object)n.getLocation());
            }
        }
        switch (request.getForeignIdHashSource()) {
            case NODE_LABEL: {
                n.setForeignId(this.computeHashCode(nodeLabel));
                LOG.debug("Generating foreignId from hash of nodelabel {}", (Object)nodeLabel);
                break;
            }
            case IP_ADDRESS: {
                n.setForeignId(this.computeHashCode(addr));
                LOG.debug("Generating foreignId from hash of ipAddress {}", (Object)addr);
                break;
            }
            case NODE_LABEL_AND_IP_ADDRESS: {
                n.setForeignId(this.computeHashCode(nodeLabel + addr));
                LOG.debug("Generating foreignId from hash of nodelabel+ipAddress {}{}", (Object)nodeLabel, (Object)addr);
                break;
            }
            default: {
                n.setForeignId(this.computeHashCode(nodeLabel));
                LOG.debug("Default case: Generating foreignId from hash of nodelabel {}", (Object)nodeLabel);
            }
        }
        n.setNodeLabel(nodeLabel);
        RequisitionInterface i = new RequisitionInterface();
        i.setDescr("DNS-" + Type.string((int)rec.getType()));
        i.setIpAddr(addr);
        i.setSnmpPrimary(PrimaryType.PRIMARY);
        i.setManaged(Boolean.TRUE);
        i.setStatus(Integer.valueOf(1));
        for (String service : request.getServices()) {
            service = service.trim();
            i.insertMonitoredService(new RequisitionMonitoredService(service));
            LOG.debug("Adding provisioned service {}", (Object)service);
        }
        n.putInterface(i);
        return n;
    }

    private String computeHashCode(String hashSource) {
        return String.valueOf(hashSource.hashCode());
    }
}

