/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.shell;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.opennms.netmgt.telemetry.api.TelemetryManager;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.shell.Format;
import org.opennms.netmgt.telemetry.shell.Utils;

@Command(scope="opennms", name="telemetry-parsers", description="Lists configured telemetry parsers")
@Service
public class Parsers
implements Action {
    @Reference
    public TelemetryManager manager;
    @Argument(index=0, name="listener", description="The listener to show parsers for", required=true, multiValued=false)
    @Completion(value=ListenerCompleter.class)
    public String listener;
    @Argument(index=1, name="parser", description="Filter parsers shown by this RegEx", required=false)
    public String parserFilter = ".*";
    @Option(name="-s", aliases={"--state"}, description="Show internal state", required=false, multiValued=false)
    public boolean showState = false;
    @Option(name="-f", aliases={"--format"}, description="Dump data in given format", required=false, multiValued=false)
    @Completion(value=StringsCompleter.class, values={"PLAIN", "JSON"})
    public Format format = Format.PLAIN;

    public Object execute() {
        Optional<Listener> listener = this.manager.getListeners().stream().filter(l -> Objects.equals(l.getName(), this.listener)).findAny();
        if (listener.isPresent()) {
            List<JsonObject> output = listener.get().getParsers().stream().filter(parser -> parser.getName().matches(this.parserFilter)).map(parser -> {
                JsonObject data = new JsonObject();
                data.addProperty("name", parser.getName());
                data.addProperty("description", parser.getDescription());
                data.add("properties", (JsonElement)Utils.getWritableProperties(parser));
                if (this.showState) {
                    data.add("state", Utils.GSON.toJsonTree(parser.dumpInternalState()));
                }
                return data;
            }).collect(Collectors.toList());
            this.format.print(output);
        } else {
            System.err.printf("No such listener: %s\n", this.listener);
        }
        return null;
    }

    @Service
    public static class ListenerCompleter
    implements Completer {
        @Reference
        public TelemetryManager manager;

        public int complete(Session session, CommandLine commandLine, List<String> candidates) {
            StringsCompleter delegate = new StringsCompleter((Collection)this.manager.getListeners().stream().map(Listener::getName).collect(Collectors.toList()));
            return delegate.complete(session, commandLine, candidates);
        }
    }
}

