/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.xml.JaxbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathXmlLoader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathXmlLoader.class);
    private final ClassLoader classLoader;
    private final Class<T> objectClazz;
    private final String subFolder;
    private final String[] fileNames;

    public ClasspathXmlLoader(Class<?> clazzForClassloader, Class<T> objectClazz, String subFolder, String ... fileNames) {
        this.classLoader = Objects.requireNonNull(clazzForClassloader).getClassLoader();
        this.objectClazz = Objects.requireNonNull(objectClazz);
        this.subFolder = Objects.requireNonNull(subFolder);
        this.fileNames = fileNames;
    }

    public List<T> getObjects() {
        LinkedList<T> allObjects = new LinkedList<T>();
        for (String fileName : this.fileNames) {
            try (InputStream is = this.classLoader.getResourceAsStream(this.subFolder + File.separator + fileName);){
                if (is == null) continue;
                T object = JaxbUtils.fromXml(is, this.objectClazz);
                allObjects.add(object);
            }
            catch (IOException e) {
                LOG.warn("Failed to load {}. Skipping.", (Object)fileName, (Object)e);
            }
        }
        return allObjects;
    }
}

