/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.config.poller.AddressRange;
import org.opennms.integration.api.v1.config.poller.Downtime;
import org.opennms.integration.api.v1.config.poller.Monitor;
import org.opennms.integration.api.v1.config.poller.Package;
import org.opennms.integration.api.v1.config.poller.Parameter;
import org.opennms.integration.api.v1.config.poller.PollerConfigurationExtension;
import org.opennms.integration.api.v1.config.poller.Rrd;
import org.opennms.integration.api.v1.config.poller.Service;
import org.opennms.integration.api.xml.ClasspathXmlLoader;
import org.opennms.integration.api.xml.schema.poller.AddressRangeXml;
import org.opennms.integration.api.xml.schema.poller.DowntimeXml;
import org.opennms.integration.api.xml.schema.poller.MonitorXml;
import org.opennms.integration.api.xml.schema.poller.PackageXml;
import org.opennms.integration.api.xml.schema.poller.ParameterXml;
import org.opennms.integration.api.xml.schema.poller.PollerConfigurationXml;
import org.opennms.integration.api.xml.schema.poller.RrdXml;
import org.opennms.integration.api.xml.schema.poller.ServiceXml;
import org.opennms.shaded.com.google.common.base.MoreObjects;

public class ClasspathPollerConfigurationLoader
extends ClasspathXmlLoader<PollerConfigurationXml> {
    public ClasspathPollerConfigurationLoader(Class<?> clazz, String subFolder, String ... fileNames) {
        super(clazz, PollerConfigurationXml.class, subFolder, fileNames);
    }

    public PollerConfigurationExtension getPollerConfiguration() {
        final List configurations = this.getObjects();
        return new PollerConfigurationExtension(){

            public List<Package> getPackages() {
                return configurations.stream().flatMap(c -> c.getPackages().stream()).map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toUnmodifiableList());
            }

            public List<Monitor> getMonitors() {
                return configurations.stream().flatMap(c -> c.getMonitors().stream()).map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toUnmodifiableList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("PollerConfigurationExtension").add("packages", this.getPackages()).add("monitors", this.getMonitors()).toString();
            }
        };
    }

    private static Package mapXml(final PackageXml source) {
        return new Package(){

            public String getName() {
                return source.getName();
            }

            public String getFilter() {
                return source.getFilter();
            }

            public List<String> getSpecifics() {
                return source.getSpecifics();
            }

            public List<AddressRange> getIncludeRanges() {
                return source.getIncludeRanges().stream().map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public List<AddressRange> getExcludeRanges() {
                return source.getExcludeRanges().stream().map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public Rrd getRrd() {
                return ClasspathPollerConfigurationLoader.mapXml(source.getRrd());
            }

            public List<Service> getServices() {
                return source.getServices().stream().map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public List<String> getOutageCalendars() {
                return source.getOutageCalendars();
            }

            public List<Downtime> getDowntimes() {
                return source.getDowntimes().stream().map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("Package").add("name", this.getName()).add("filter", this.getFilter()).add("specific", this.getSpecifics()).add("includeRange", this.getIncludeRanges()).add("excludeRange", this.getExcludeRanges()).add("rrd", this.getRrd()).add("services", this.getServices()).add("outageCalendars", this.getOutageCalendars()).add("downtimes", this.getDowntimes()).toString();
            }
        };
    }

    private static Downtime mapXml(final DowntimeXml downtime) {
        return new Downtime(){

            public Duration getBegin() {
                return Duration.ofSeconds(downtime.getBegin());
            }

            public Optional<Duration> getEnd() {
                return Optional.ofNullable(downtime.getEnd()).map(Duration::ofSeconds);
            }

            public Optional<Downtime.DeletingMode> getDelete() {
                DowntimeXml.Delete delete = downtime.getDelete();
                return Optional.ofNullable(delete).map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0));
            }

            public Optional<Long> getInterval() {
                return Optional.ofNullable(downtime.getInterval());
            }

            public String toString() {
                return MoreObjects.toStringHelper("Downtime").add("begin", this.getBegin()).add("end", this.getEnd()).add("delete", this.getDelete()).toString();
            }
        };
    }

    private static Downtime.DeletingMode mapXml(DowntimeXml.Delete delete) {
        switch (delete) {
            case ALWAYS: {
                return Downtime.DeletingMode.ALWAYS;
            }
            case MANAGED: {
                return Downtime.DeletingMode.MANAGED;
            }
            case NEVER: {
                return Downtime.DeletingMode.NEVER;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Service mapXml(final ServiceXml serviceXml) {
        return new Service(){

            public String getName() {
                return serviceXml.getName();
            }

            public long getInterval() {
                return serviceXml.getInterval();
            }

            public Optional<String> getPattern() {
                return Optional.ofNullable(serviceXml.getPattern());
            }

            public List<Parameter> getParameters() {
                return serviceXml.getParameters().stream().map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("Service").add("name", this.getName()).add("interval", this.getInterval()).add("pattern", this.getPattern()).add("parameters", this.getParameters()).toString();
            }
        };
    }

    private static Parameter mapXml(final ParameterXml parameterXml) {
        return new Parameter(){

            public String getKey() {
                return parameterXml.getKey();
            }

            public String getValue() {
                return parameterXml.getValue();
            }

            public String toString() {
                return MoreObjects.toStringHelper("Parameter").add("key", this.getKey()).add("value", this.getValue()).toString();
            }
        };
    }

    private static AddressRange mapXml(final AddressRangeXml addressRangeXml) {
        return new AddressRange(){

            public String getBegin() {
                return addressRangeXml.getBegin();
            }

            public String getEnd() {
                return addressRangeXml.getEnd();
            }

            public String toString() {
                return MoreObjects.toStringHelper("AddressRange").add("begin", this.getBegin()).add("end", this.getEnd()).toString();
            }
        };
    }

    private static Monitor mapXml(final MonitorXml monitor) {
        return new Monitor(){

            public String getService() {
                return monitor.getService();
            }

            public String getClassName() {
                return monitor.getClassName();
            }

            public List<Parameter> getParameters() {
                return monitor.getParameters().stream().map(x$0 -> ClasspathPollerConfigurationLoader.mapXml(x$0)).collect(Collectors.toList());
            }

            public String toString() {
                return MoreObjects.toStringHelper("Monitor").add("service", this.getService()).add("className", this.getClassName()).add("parameters", this.getParameters()).toString();
            }
        };
    }

    private static Rrd mapXml(final RrdXml rrd) {
        return new Rrd(){

            public int getStep() {
                return rrd.getStep();
            }

            public List<String> getRras() {
                return rrd.getRras();
            }

            public String toString() {
                return MoreObjects.toStringHelper("RRD").add("step", this.getStep()).add("rras", this.getRras()).toString();
            }
        };
    }
}

