/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd.jmx;

import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.trapd.jmx.DeviceConsumerTrapMetrics;
import org.opennms.netmgt.trapd.jmx.DeviceTrapMetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapdInstrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(TrapdInstrumentation.class);
    private static final String DEVICE_METRICS_FLAG = "org.opennms.netmgt.trapd.enableDeviceMetrics";
    private final DeviceTrapMetricsRegistry<DeviceConsumerTrapMetrics> deviceRegistry;
    private final AtomicLong trapsReceived = new AtomicLong();
    private final AtomicLong v1TrapsReceived = new AtomicLong();
    private final AtomicLong v2cTrapsReceived = new AtomicLong();
    private final AtomicLong v3TrapsReceived = new AtomicLong();
    private final AtomicLong vUnknownTrapsReceived = new AtomicLong();
    private final AtomicLong trapsDiscarded = new AtomicLong();
    private final AtomicLong trapsErrored = new AtomicLong();
    private final AtomicLong rawTrapsReceived = new AtomicLong();
    private int maxQueueSize = 0;
    private int batchSize = 0;
    private Supplier<Integer> queueSizeSupplier = () -> 0;

    public TrapdInstrumentation() {
        boolean enabled = Boolean.getBoolean(DEVICE_METRICS_FLAG);
        this.deviceRegistry = new DeviceTrapMetricsRegistry<DeviceConsumerTrapMetrics>(enabled, DeviceConsumerTrapMetrics::new, "consumer");
    }

    public void incTrapsReceivedCount(String version) {
        this.trapsReceived.incrementAndGet();
        if ("v1".equals(version)) {
            this.v1TrapsReceived.incrementAndGet();
        } else if ("v2c".equals(version) || "v2".equals(version)) {
            this.v2cTrapsReceived.incrementAndGet();
        } else if ("v3".equals(version)) {
            this.v3TrapsReceived.incrementAndGet();
        } else {
            this.vUnknownTrapsReceived.incrementAndGet();
            LOG.warn("Received a trap with an unknown SNMP protocol version '{}'.", (Object)version);
        }
    }

    public void incTrapsReceivedCount(String version, String location, InetAddress trapAddress) {
        this.incTrapsReceivedCount(version);
        DeviceConsumerTrapMetrics device = this.getDeviceMetrics(location, trapAddress);
        if (device != null) {
            device.incTrapsReceived();
        }
    }

    public void incDiscardCount() {
        this.trapsDiscarded.incrementAndGet();
    }

    public void incDiscardCount(String location, InetAddress trapAddress) {
        this.incDiscardCount();
        DeviceConsumerTrapMetrics device = this.getDeviceMetrics(location, trapAddress);
        if (device != null) {
            device.incTrapsDiscarded();
        }
    }

    public void incErrorCount() {
        this.trapsErrored.incrementAndGet();
    }

    public void incErrorCount(String location, InetAddress trapAddress) {
        this.incErrorCount();
        DeviceConsumerTrapMetrics device = this.getDeviceMetrics(location, trapAddress);
        if (device != null) {
            device.incTrapsErrored();
        }
    }

    public long getV1TrapsReceived() {
        return this.v1TrapsReceived.get();
    }

    public long getV2cTrapsReceived() {
        return this.v2cTrapsReceived.get();
    }

    public long getV3TrapsReceived() {
        return this.v3TrapsReceived.get();
    }

    public long getVUnknownTrapsReceived() {
        return this.vUnknownTrapsReceived.get();
    }

    public long getTrapsDiscarded() {
        return this.trapsDiscarded.get();
    }

    public long getTrapsErrored() {
        return this.trapsErrored.get();
    }

    public long getTrapsReceived() {
        return this.trapsReceived.get();
    }

    public void incRawTrapsReceivedCount() {
        this.rawTrapsReceived.incrementAndGet();
    }

    public long getRawTrapsReceived() {
        return this.rawTrapsReceived.get();
    }

    public void setMaxQueueSize(int size) {
        this.maxQueueSize = size;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setQueueSizeSupplier(Supplier<Integer> supplier) {
        this.queueSizeSupplier = supplier != null ? supplier : () -> 0;
    }

    public int getCurrentQueueSize() {
        return this.queueSizeSupplier.get();
    }

    public void shutdown() {
        this.deviceRegistry.shutdown();
    }

    private DeviceConsumerTrapMetrics getDeviceMetrics(String location, InetAddress trapAddress) {
        if (location == null || trapAddress == null) {
            return null;
        }
        return this.deviceRegistry.getOrCreate(location, InetAddressUtils.str((InetAddress)trapAddress));
    }
}

