/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import java.net.InetAddress;
import java.util.function.Supplier;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.trapd.jmx.DeviceTrapMetrics;
import org.opennms.netmgt.trapd.jmx.DeviceTrapMetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapListenerMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(TrapListenerMetrics.class);
    private static final String JMX_DOMAIN = "org.opennms.netmgt.trapd";
    private static final String DEVICE_METRICS_PROPERTY = "org.opennms.netmgt.trapd.enableDeviceMetrics";
    private final MetricRegistry metrics;
    private JmxReporter jmxReporter;
    private final Counter rawTrapsReceived;
    private final Counter trapsErrored;
    private Supplier<Integer> queueSizeSupplier = () -> 0;
    private int maxQueueSize = 0;
    private int batchSize = 0;
    private final Identity identity;
    private final DeviceTrapMetricsRegistry<DeviceTrapMetrics> deviceRegistry;

    public TrapListenerMetrics(MetricRegistry metrics) {
        this(metrics, null, false);
    }

    public TrapListenerMetrics(MetricRegistry metrics, Identity identity, boolean enableDeviceMetrics) {
        this.metrics = metrics;
        this.identity = identity;
        boolean deviceMetricsEnabled = enableDeviceMetrics || Boolean.getBoolean(DEVICE_METRICS_PROPERTY);
        this.deviceRegistry = new DeviceTrapMetricsRegistry<DeviceTrapMetrics>(deviceMetricsEnabled, DeviceTrapMetrics::new, "listener");
        this.rawTrapsReceived = metrics.counter(this.name("rawTrapsReceived"));
        this.trapsErrored = metrics.counter(this.name("trapsErrored"));
        metrics.register(this.name("currentQueueSize"), (Metric)((Gauge)() -> this.queueSizeSupplier.get()));
        metrics.register(this.name("maxQueueSize"), (Metric)((Gauge)() -> this.maxQueueSize));
        metrics.register(this.name("batchSize"), (Metric)((Gauge)() -> this.batchSize));
    }

    private String name(String metric) {
        return metric;
    }

    public void startJmxReporter() {
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).inDomain(JMX_DOMAIN).build();
        this.jmxReporter.start();
    }

    public void stopJmxReporter() {
        if (this.jmxReporter != null) {
            this.jmxReporter.close();
            this.jmxReporter = null;
        }
        this.deviceRegistry.shutdown();
    }

    public void incRawTrapsReceivedCount() {
        this.rawTrapsReceived.inc();
    }

    public void incRawTrapsReceivedCount(InetAddress trapAddress) {
        this.rawTrapsReceived.inc();
        DeviceTrapMetrics device = this.getDeviceMetrics(trapAddress);
        if (device != null) {
            device.incRawTrapsReceived();
        }
    }

    public void incErrorCount() {
        this.trapsErrored.inc();
    }

    public void incErrorCount(InetAddress trapAddress) {
        this.trapsErrored.inc();
        DeviceTrapMetrics device = this.getDeviceMetrics(trapAddress);
        if (device != null) {
            device.incTrapsErrored();
        }
    }

    public void setQueueSizeSupplier(Supplier<Integer> supplier) {
        this.queueSizeSupplier = supplier != null ? supplier : () -> 0;
    }

    public void setMaxQueueSize(int size) {
        this.maxQueueSize = size;
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    private DeviceTrapMetrics getDeviceMetrics(InetAddress trapAddress) {
        if (trapAddress == null) {
            return null;
        }
        String location = this.identity != null ? this.identity.getLocation() : "Default";
        return this.deviceRegistry.getOrCreate(location, InetAddressUtils.str((InetAddress)trapAddress));
    }
}

