/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.cache;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class CacheConfig {
    private String name;
    private boolean enabled = true;
    private Long maximumSize;
    private Long expireAfterWrite;
    private Long expireAfterRead;
    private boolean recordStats;
    private MetricRegistry metricRegistry;

    protected CacheConfig() {
    }

    public CacheConfig(String cacheName) {
        this.name = Objects.requireNonNull(cacheName);
    }

    public Long getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Long maxSize) {
        this.maximumSize = maxSize;
    }

    public Long getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(Long expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public boolean isRecordStats() {
        return this.recordStats;
    }

    public void setRecordStats(boolean recordStats) {
        this.recordStats = recordStats;
    }

    public Long getExpireAfterRead() {
        return this.expireAfterRead;
    }

    public void setExpireAfterRead(Long expireAfterRead) {
        this.expireAfterRead = expireAfterRead;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected <K, V> CacheBuilder<K, V> createBuilder() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.getMaximumSize() != null && this.getMaximumSize() > 0L) {
            cacheBuilder.maximumSize(this.getMaximumSize().longValue());
        }
        if (this.getExpireAfterWrite() != null && this.getExpireAfterWrite() > 0L) {
            cacheBuilder.expireAfterWrite(this.getExpireAfterWrite().longValue(), TimeUnit.SECONDS);
        }
        if (this.getExpireAfterRead() != null && this.getExpireAfterRead() > 0L) {
            cacheBuilder.expireAfterAccess(this.getExpireAfterRead().longValue(), TimeUnit.SECONDS);
        }
        if (this.isRecordStats()) {
            cacheBuilder.recordStats();
        }
        return cacheBuilder;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("maximumSize", (Object)this.maximumSize).add("expireAfterWrite", this.expireAfterWrite != null ? this.expireAfterWrite + " sec" : null).add("expireAfterRead", this.expireAfterRead != null ? this.expireAfterRead + " sec" : null).add("recordStats", this.recordStats).toString();
    }

    public void validate() {
        if (this.name == null || "".equals(this.name.trim())) {
            throw new IllegalStateException("Cache has no name");
        }
        if (this.recordStats && this.metricRegistry == null) {
            throw new IllegalStateException("Cache '" + this.name + "' should record statistics, but no MetricRegistry is provided");
        }
    }
}

