/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import org.jrobin.core.Util;
import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;

class ValueAxisMrtg
implements RrdGraphConstants {
    private ImageParameters im;
    private ImageWorker worker;
    private RrdGraphDef gdef;

    ValueAxisMrtg(RrdGraph rrdGraph) {
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
        this.im.unit = this.gdef.unit;
    }

    boolean draw() {
        Font font = this.gdef.getFont(2);
        Paint mGridColor = this.gdef.colors[5];
        Paint fontColor = this.gdef.colors[6];
        int labelOffset = (int)(this.worker.getFontAscent(font) / 2.0);
        if (Double.isNaN((this.im.maxval - this.im.minval) / this.im.magfact)) {
            return false;
        }
        int xLeft = this.im.xorigin;
        int xRight = this.im.xorigin + this.im.xsize;
        String labfmt = this.im.scaledstep / this.im.magfact * (double)Math.max(Math.abs(this.im.quadrant), Math.abs(4 - this.im.quadrant)) <= 1.0 ? "%5.2f" : Util.sprintf("%%4.%df", 1 - (this.im.scaledstep / this.im.magfact > 10.0 || Math.ceil(this.im.scaledstep / this.im.magfact) == this.im.scaledstep / this.im.magfact ? 1 : 0));
        if (this.im.symbol != ' ' || this.im.unit != null) {
            labfmt = labfmt + " ";
        }
        if (this.im.symbol != ' ') {
            labfmt = labfmt + this.im.symbol;
        }
        if (this.im.unit != null) {
            labfmt = labfmt + this.im.unit;
        }
        for (int i = 0; i <= 4; ++i) {
            int y = this.im.yorigin - this.im.ysize * i / 4;
            if (y < this.im.yorigin - this.im.ysize || y > this.im.yorigin) continue;
            String graph_label = Util.sprintf(labfmt, this.im.scaledstep / this.im.magfact * (double)(i - this.im.quadrant));
            int length = (int)this.worker.getStringWidth(graph_label, font);
            this.worker.drawString(graph_label, xLeft - length - 7, y + labelOffset, font, fontColor);
            this.worker.drawLine(xLeft - 2, y, xLeft + 2, y, mGridColor, TICK_STROKE);
            this.worker.drawLine(xRight - 2, y, xRight + 2, y, mGridColor, TICK_STROKE);
            this.worker.drawLine(xLeft, y, xRight, y, mGridColor, GRID_STROKE);
        }
        return true;
    }
}

