/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.DataImporter;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.jrrd.RRDatabase;

class RrdToolReader
extends DataImporter {
    private RRDatabase rrd;

    RrdToolReader(String rrdPath) throws IOException, RrdException {
        this.rrd = new RRDatabase(rrdPath);
    }

    @Override
    String getVersion() {
        return this.rrd.getHeader().getVersion();
    }

    @Override
    long getLastUpdateTime() {
        return Util.getTimestamp(this.rrd.getLastUpdate());
    }

    @Override
    long getStep() {
        return this.rrd.getHeader().getPDPStep();
    }

    @Override
    int getDsCount() {
        return this.rrd.getHeader().getDSCount();
    }

    @Override
    int getArcCount() throws RrdException, IOException {
        return this.rrd.getNumArchives();
    }

    @Override
    String getDsName(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getName();
    }

    @Override
    String getDsType(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getType().toString();
    }

    @Override
    long getHeartbeat(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMinimumHeartbeat();
    }

    @Override
    double getMinValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMinimum();
    }

    @Override
    double getMaxValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMaximum();
    }

    @Override
    double getLastValue(int dsIndex) {
        String valueStr = this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getLastReading();
        return Util.parseDouble(valueStr);
    }

    @Override
    double getAccumValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getValue();
    }

    @Override
    long getNanSeconds(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getUnknownSeconds();
    }

    @Override
    String getConsolFun(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getType().toString();
    }

    @Override
    double getXff(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getXff();
    }

    @Override
    int getSteps(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getPdpCount();
    }

    @Override
    int getRows(int arcIndex) throws RrdException, IOException {
        return this.rrd.getArchive(arcIndex).getRowCount();
    }

    @Override
    double getStateAccumValue(int arcIndex, int dsIndex) throws RrdException, IOException {
        return this.rrd.getArchive(arcIndex).getCDPStatusBlock(dsIndex).getValue();
    }

    @Override
    int getStateNanSteps(int arcIndex, int dsIndex) throws RrdException, IOException {
        return this.rrd.getArchive(arcIndex).getCDPStatusBlock(dsIndex).getUnknownDatapoints();
    }

    @Override
    double[] getValues(int arcIndex, int dsIndex) throws RrdException, IOException, RrdException {
        return this.rrd.getArchive(arcIndex).getValues()[dsIndex];
    }

    @Override
    void release() throws IOException {
        if (this.rrd != null) {
            this.rrd.close();
            this.rrd = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }
}

