/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.response;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.asteriskjava.manager.response.ManagerResponse;

public class GetConfigResponse
extends ManagerResponse {
    private static final long serialVersionUID = -2044248427247227390L;
    private Map<Integer, String> categories;
    private Map<Integer, Map<Integer, String>> lines;

    public Map<Integer, String> getCategories() {
        if (this.categories == null) {
            this.categories = new TreeMap<Integer, String>();
        }
        Map<String, Object> responseMap = super.getAttributes();
        Set<String> responseKeys = responseMap.keySet();
        for (String key : responseKeys) {
            Integer categoryNumber;
            String[] keyParts;
            if (!key.toLowerCase(Locale.US).contains("category") || (keyParts = key.split("-")).length < 2) continue;
            try {
                categoryNumber = Integer.parseInt(keyParts[1]);
            }
            catch (Exception exception) {
                continue;
            }
            this.categories.put(categoryNumber, (String)responseMap.get(key));
        }
        return this.categories;
    }

    public Map<Integer, String> getLines(int categoryNumber) {
        if (this.lines == null) {
            this.lines = new TreeMap<Integer, Map<Integer, String>>();
        }
        Map<String, Object> responseMap = super.getAttributes();
        Set<String> responseKeys = responseMap.keySet();
        for (String key : responseKeys) {
            Integer potentialLineNumber;
            Integer potentialCategoryNumber;
            String[] keyParts;
            if (!key.toLowerCase(Locale.US).contains("line") || (keyParts = key.split("-")).length < 3) continue;
            try {
                potentialCategoryNumber = Integer.parseInt(keyParts[1]);
            }
            catch (Exception exception) {
                continue;
            }
            try {
                potentialLineNumber = Integer.parseInt(keyParts[2]);
            }
            catch (Exception exception) {
                continue;
            }
            Map<Integer, String> linesForCategory = this.lines.get(potentialCategoryNumber);
            if (linesForCategory == null) {
                linesForCategory = new TreeMap<Integer, String>();
            }
            linesForCategory.put(potentialLineNumber, (String)responseMap.get(key));
            if (this.lines.containsKey(potentialCategoryNumber)) continue;
            this.lines.put(potentialCategoryNumber, linesForCategory);
        }
        return this.lines.get(categoryNumber);
    }
}

