/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.RestrictionVisitor;
import org.opennms.netmgt.dao.mock.BeanWrapperRestrictionVisitor;

public class BeanWrapperCriteriaVisitor
implements Criteria.CriteriaVisitor {
    private List<Order> m_orders = new ArrayList<Order>();
    private List<Alias> m_aliases = new ArrayList<Alias>();
    private List<Fetch> m_fetches = new ArrayList<Fetch>();
    private boolean m_distinct = false;
    private Integer m_limit = 0;
    private Integer m_offset = 0;
    private List<?> m_entities;
    private List<?> m_matching;

    public BeanWrapperCriteriaVisitor(Object ... obj) {
        this.m_entities = Arrays.asList(obj);
        this.m_matching = Arrays.asList(obj);
    }

    public BeanWrapperCriteriaVisitor(List<?> obj) {
        this.m_entities = obj;
        this.m_matching = new ArrayList(obj);
    }

    public void reset() {
        this.m_matching = new ArrayList(this.m_entities);
    }

    public void visitClassAndRootAlias(Class<?> clazz, String rootAlias) {
        ArrayList matching = new ArrayList();
        for (Object o : this.m_matching) {
            if (!o.getClass().isAssignableFrom(clazz)) continue;
            matching.add(o);
        }
        this.m_matching = matching;
    }

    public void visitOrder(Order order) {
        this.m_orders.add(order);
    }

    public void visitOrdersFinished() {
    }

    public void visitAlias(Alias alias) {
        this.m_aliases.add(alias);
    }

    public void visitAliasesFinished() {
    }

    public void visitLockType(Criteria.LockType lock) {
    }

    public void visitFetch(Fetch fetch) {
        this.m_fetches.add(fetch);
    }

    public void visitFetchesFinished() {
    }

    public void visitRestriction(Restriction restriction) {
        ArrayList matching = new ArrayList();
        for (Object entity : this.m_matching) {
            BeanWrapperRestrictionVisitor visitor = new BeanWrapperRestrictionVisitor(entity, this.m_aliases);
            restriction.visit((RestrictionVisitor)visitor);
            if (!visitor.matches()) continue;
            matching.add(entity);
        }
        this.m_matching = matching;
    }

    public void visitRestrictionsFinished() {
    }

    public void visitDistinct(boolean distinct) {
        this.m_distinct = distinct;
    }

    public void visitLimit(Integer limit) {
        this.m_limit = limit;
    }

    public void visitOffset(Integer offset) {
        this.m_offset = offset;
    }

    public Collection<?> getMatches() {
        List<Object> matches = new ArrayList(this.m_matching);
        if (this.m_offset != null && this.m_offset > 0) {
            matches = matches.subList(this.m_offset, matches.size());
        }
        if (this.m_limit != null && this.m_limit > 0) {
            matches = matches.subList(0, this.m_limit);
        }
        if (this.m_distinct) {
            return new LinkedHashSet(matches);
        }
        return new ArrayList(matches);
    }
}

