/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.dao.api.AlarmAssociationDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.LegacyOnmsDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.mock.BeanWrapperCriteriaVisitor;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class AbstractMockDao<T, K extends Serializable>
implements LegacyOnmsDao<T, K>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMockDao.class);
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    private Map<K, T> m_entries = Collections.synchronizedMap(new HashMap());
    private IpInterfaceDao m_ipInterfaceDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private AssetRecordDao m_assetRecordDao;
    private CategoryDao m_categoryDao;
    private MonitoringLocationDao m_locationDao;
    private DistPollerDao m_distPollerDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private ServiceTypeDao m_serviceTypeDao;
    private AlarmDao m_alarmDao;
    private AlarmAssociationDao m_alarmAssociationDao;
    private EventDao m_eventDao;
    private NodeDao m_nodeDao;

    protected abstract K getId(T var1);

    protected abstract void generateId(T var1);

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_serviceRegistry);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.m_serviceRegistry;
    }

    public void lock() {
    }

    public void initialize(Object obj) {
    }

    public void flush() {
    }

    public void clear() {
    }

    public int countAll() {
        LOG.trace("countAll()");
        return this.findAll().size();
    }

    public void delete(T entity) {
        LOG.trace("delete({})", entity);
        this.m_entries.remove(this.getId(entity));
    }

    public void delete(K key) {
        this.delete((K)this.get(key));
    }

    public List<T> findAll() {
        LOG.trace("findAll()");
        return new ArrayList<T>(this.m_entries.values());
    }

    public List<T> findMatching(Criteria criteria) {
        BeanWrapperCriteriaVisitor visitor = new BeanWrapperCriteriaVisitor(this.findAll());
        criteria.visit((Criteria.CriteriaVisitor)visitor);
        Collection<?> matches = visitor.getMatches();
        return new ArrayList(matches);
    }

    public List<T> findMatching(OnmsCriteria criteria) {
        LOG.trace("findMatching({})", (Object)criteria);
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public int countMatching(Criteria onmsCrit) {
        LOG.trace("countMatching({})", (Object)onmsCrit);
        List<T> matched = this.findMatching(onmsCrit);
        return matched == null ? 0 : matched.size();
    }

    public int countMatching(OnmsCriteria onmsCrit) {
        LOG.trace("countMatching({})", (Object)onmsCrit);
        List<T> matched = this.findMatching(onmsCrit);
        return matched == null ? 0 : matched.size();
    }

    public T get(K id) {
        T retval = this.m_entries.get(id);
        if (LOG.isTraceEnabled()) {
            LOG.trace("get({}: {})", (Object)(retval == null ? "null" : retval.getClass().getSimpleName()), id);
        }
        return retval;
    }

    public T load(K id) {
        T retval = this.m_entries.get(id);
        if (LOG.isTraceEnabled()) {
            LOG.trace("load({}: {})", (Object)(retval == null ? "null" : retval.getClass().getSimpleName()), id);
        }
        return retval;
    }

    public K save(T entity) {
        if (entity == null) {
            return null;
        }
        K id = this.getId(entity);
        if (id == null) {
            this.generateId(entity);
            id = this.getId(entity);
        }
        if (this.m_entries.containsKey(id)) {
            LOG.debug("save({}): id already exists: {}", entity, id);
        } else {
            LOG.trace("save({})", entity);
        }
        this.m_entries.put(id, entity);
        return id;
    }

    public void saveOrUpdate(T entity) {
        if (this.getId(entity) == null) {
            this.save(entity);
        } else {
            this.update(entity);
        }
    }

    public void update(T entity) {
        LOG.trace("update({})", entity);
        K id = this.getId(entity);
        T existingEntity = this.get(id);
        if (!entity.equals(existingEntity)) {
            LOG.warn("update({}): updates do not match: {}", entity, id);
        }
        this.m_entries.put(id, entity);
    }

    protected IpInterfaceDao getIpInterfaceDao() {
        if (this.m_ipInterfaceDao == null) {
            this.m_ipInterfaceDao = (IpInterfaceDao)this.getServiceRegistry().findProvider(IpInterfaceDao.class);
            Assert.notNull((Object)this.m_ipInterfaceDao);
        }
        return this.m_ipInterfaceDao;
    }

    protected SnmpInterfaceDao getSnmpInterfaceDao() {
        if (this.m_snmpInterfaceDao == null) {
            this.m_snmpInterfaceDao = (SnmpInterfaceDao)this.getServiceRegistry().findProvider(SnmpInterfaceDao.class);
            Assert.notNull((Object)this.m_snmpInterfaceDao);
        }
        return this.m_snmpInterfaceDao;
    }

    protected AssetRecordDao getAssetRecordDao() {
        if (this.m_assetRecordDao == null) {
            this.m_assetRecordDao = (AssetRecordDao)this.getServiceRegistry().findProvider(AssetRecordDao.class);
            Assert.notNull((Object)this.m_assetRecordDao);
        }
        return this.m_assetRecordDao;
    }

    protected CategoryDao getCategoryDao() {
        if (this.m_categoryDao == null) {
            this.m_categoryDao = (CategoryDao)this.getServiceRegistry().findProvider(CategoryDao.class);
            Assert.notNull((Object)this.m_categoryDao);
        }
        return this.m_categoryDao;
    }

    protected MonitoringLocationDao getMonitoringLocationDao() {
        if (this.m_locationDao == null) {
            this.m_locationDao = (MonitoringLocationDao)this.getServiceRegistry().findProvider(MonitoringLocationDao.class);
            Assert.notNull((Object)this.m_locationDao);
        }
        return this.m_locationDao;
    }

    protected DistPollerDao getDistPollerDao() {
        if (this.m_distPollerDao == null) {
            this.m_distPollerDao = (DistPollerDao)this.getServiceRegistry().findProvider(DistPollerDao.class);
            Assert.notNull((Object)this.m_distPollerDao);
        }
        return this.m_distPollerDao;
    }

    protected MonitoredServiceDao getMonitoredServiceDao() {
        if (this.m_monitoredServiceDao == null) {
            this.m_monitoredServiceDao = (MonitoredServiceDao)this.getServiceRegistry().findProvider(MonitoredServiceDao.class);
            Assert.notNull((Object)this.m_monitoredServiceDao);
        }
        return this.m_monitoredServiceDao;
    }

    protected ServiceTypeDao getServiceTypeDao() {
        if (this.m_serviceTypeDao == null) {
            this.m_serviceTypeDao = (ServiceTypeDao)this.getServiceRegistry().findProvider(ServiceTypeDao.class);
            Assert.notNull((Object)this.m_serviceTypeDao);
        }
        return this.m_serviceTypeDao;
    }

    protected EventDao getEventDao() {
        if (this.m_eventDao == null) {
            this.m_eventDao = (EventDao)this.getServiceRegistry().findProvider(EventDao.class);
            Assert.notNull((Object)this.m_eventDao);
        }
        return this.m_eventDao;
    }

    protected AlarmDao getAlarmDao() {
        if (this.m_alarmDao == null) {
            this.m_alarmDao = (AlarmDao)this.getServiceRegistry().findProvider(AlarmDao.class);
            Assert.notNull((Object)this.m_alarmDao);
        }
        return this.m_alarmDao;
    }

    protected AlarmAssociationDao getAlarmAssociationDao() {
        if (this.m_alarmAssociationDao == null) {
            this.m_alarmAssociationDao = (AlarmAssociationDao)this.getServiceRegistry().findProvider(AlarmAssociationDao.class);
            Assert.notNull((Object)this.m_alarmAssociationDao);
        }
        return this.m_alarmAssociationDao;
    }

    protected NodeDao getNodeDao() {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)this.getServiceRegistry().findProvider(NodeDao.class);
            Assert.notNull((Object)this.m_nodeDao);
        }
        return this.m_nodeDao;
    }

    public static final class NullEventForwarder
    implements EventForwarder {
        public void sendNow(Event event) {
        }

        public void sendNow(Log eventLog) {
        }

        public void sendNowSync(Event event) {
        }

        public void sendNowSync(Log eventLog) {
        }
    }
}

