/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.filters.shell;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceRef;
import org.opennms.netmgt.dao.api.ServiceTracker;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;

@Command(scope="opennms", name="track-service", description="Track services that match a given filter")
@Service
public class TrackServiceCommand
implements Action {
    @Reference
    private NodeDao nodeDao;
    @Reference
    private SessionUtils sessionUtils;
    @Reference
    private ServiceTracker serviceTracker;
    @Argument(index=0, description="Service name", required=true)
    private String serviceName;
    @Argument(index=1, description="Filter Rule", required=false)
    private String filterRule;

    public Object execute() throws IOException {
        System.out.printf("Tracking service named %s%s. Press CTRL+C to stop.\n", this.serviceName, this.filterRule != null ? String.format(" with filter rule \"%s\"", this.filterRule) : "");
        final LinkedBlockingDeque messageQueue = new LinkedBlockingDeque();
        Closeable session = this.serviceTracker.trackServiceMatchingFilterRule(this.serviceName, this.filterRule, new ServiceTracker.ServiceListener(){

            public void onServiceMatched(ServiceRef serviceRef) {
                messageQueue.add(String.format("FOUND: %s\n", TrackServiceCommand.this.getDescription(serviceRef)));
            }

            public void onServiceStoppedMatching(ServiceRef serviceRef) {
                messageQueue.add(String.format("REMOVED: %s\n", TrackServiceCommand.this.getDescription(serviceRef)));
            }
        });
        try {
            while (true) {
                System.out.print((String)messageQueue.take());
            }
        }
        catch (InterruptedException e) {
            session.close();
            return null;
        }
    }

    private String getDescription(ServiceRef serviceRef) {
        return (String)this.sessionUtils.withReadOnlyTransaction(() -> {
            String nodeLabel = "<unknown label>";
            String nodeLocation = "<unknown location>";
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(serviceRef.getNodeId()));
            if (node != null) {
                nodeLabel = node.getLabel();
                nodeLocation = node.getLocation() != null ? node.getLocation().getLocationName() : "Default";
            }
            return String.format("%s on interface %s on node %s (id=%d) at location %s.", serviceRef.getServiceName(), InetAddressUtils.str((InetAddress)serviceRef.getIpAddress()), nodeLabel, serviceRef.getNodeId(), nodeLocation);
        });
    }
}

