/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.shell;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class NamedMetricSet {
    private static final String NAME_PROP_KEY = "name";
    private static final String DESCRIPTION_PROP_KEY = "description";
    private final MetricSet metricSet;
    private final String name;
    private final String description;

    public NamedMetricSet(MetricSet metricSet, String name, String description) {
        this.metricSet = Objects.requireNonNull(metricSet);
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.length() > 0;
    }

    public String getDescription() {
        return this.description;
    }

    public MetricRegistry toMetricRegistry() {
        MetricRegistry metricRegistry = new MetricRegistry();
        metricRegistry.registerAll(this.metricSet);
        return metricRegistry;
    }

    public static List<NamedMetricSet> getNamedMetricSetsInContext(BundleContext bundleContext) {
        Collection metricSetRefs;
        HashMap<String, NamedMetricSet> metricSetsByName = new HashMap<String, NamedMetricSet>();
        try {
            metricSetRefs = bundleContext.getServiceReferences(MetricSet.class, null);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        for (ServiceReference metricSetRef : metricSetRefs) {
            String name = (String)metricSetRef.getProperty(NAME_PROP_KEY);
            String description = (String)metricSetRef.getProperty(DESCRIPTION_PROP_KEY);
            MetricSet metricSet = (MetricSet)bundleContext.getService(metricSetRef);
            metricSetsByName.putIfAbsent(name, new NamedMetricSet(metricSet, name, description));
        }
        return metricSetsByName.values().stream().sorted(Comparator.comparing(NamedMetricSet::getName)).collect(Collectors.toList());
    }
}

