/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.shell;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.health.shell.NamedMetricSet;
import org.osgi.framework.BundleContext;

@Command(scope="opennms", name="metrics-display", description="Display metrics from one or more metric sets.")
@Service
public class MetricsDisplayCommand
implements Action {
    @Option(name="-m", description="Only display metric set with names containing the given substring.")
    private String metricSetFilter;
    @Reference
    private BundleContext bundleContext;

    public Object execute() {
        List<NamedMetricSet> metricSets = NamedMetricSet.getNamedMetricSetsInContext(this.bundleContext);
        if (metricSets.size() < 1) {
            System.out.println("(No metric sets are currently available.)");
            return null;
        }
        if (this.metricSetFilter != null) {
            metricSets.removeIf(m -> !m.getName().toLowerCase().contains(this.metricSetFilter.toLowerCase()));
        }
        if (metricSets.size() < 1) {
            System.out.printf("(No metric set names match the given filter '%s'.)\n", this.metricSetFilter);
            return null;
        }
        boolean first = true;
        for (NamedMetricSet namedMetricSet : metricSets) {
            if (first) {
                first = false;
            } else {
                System.out.println("\n\n");
            }
            System.out.println("Metric set:");
            System.out.printf("%s%s\n", namedMetricSet.getName(), namedMetricSet.hasDescription() ? String.format(" (%s)", namedMetricSet.getDescription()) : "");
            MetricRegistry metricRegistry = namedMetricSet.toMetricRegistry();
            ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)metricRegistry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build();
            consoleReporter.report();
        }
        return null;
    }
}

