/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.graphml.model;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLEdge;
import org.opennms.features.graphml.model.GraphMLGraph;
import org.opennms.features.graphml.model.GraphMLNode;

public abstract class GraphMLElement {
    protected static final String ID = "id";
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public String getId() {
        return (String)this.getProperty(ID);
    }

    public void setId(String id) {
        this.setProperty(ID, Objects.requireNonNull(id));
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public <T> T getProperty(String key, T defaultValue) {
        return (T)this.properties.getOrDefault(key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public HashMap<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    public abstract <T> T accept(GraphMLElementVisitor<T> var1);

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof GraphMLElement) {
            return Objects.equals(this.properties, ((GraphMLElement)obj).properties);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add(ID, (Object)this.getId()).toString();
    }

    public static interface GraphMLElementVisitor<T> {
        public T visit(GraphMLGraph var1);

        public T visit(GraphMLNode var1);

        public T visit(GraphMLEdge var1);

        public T visit(GraphML var1);
    }
}

