/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices;

import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Analyze
extends GenericResultAbstractAction {
    protected Analyze(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        this.payload = "{\"text\": " + new Gson().toJson((Object)builder.textToAnalyze) + "}";
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_analyze";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    public static class Builder
    extends AbstractAction.Builder<Analyze, Builder> {
        private String index;
        private List<String> textToAnalyze = new ArrayList<String>();

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder text(String textToAnalyze) {
            this.textToAnalyze.add(textToAnalyze);
            return this;
        }

        public Builder text(Collection<? extends String> textToAnalyze) {
            this.textToAnalyze.addAll(textToAnalyze);
            return this;
        }

        public Builder analyzer(String analyzer) {
            return (Builder)this.setParameter("analyzer", analyzer);
        }

        public Builder field(String field) {
            return (Builder)this.setParameter("field", field);
        }

        public Builder tokenizer(String tokenizer) {
            return (Builder)this.setParameter("tokenizer", tokenizer);
        }

        public Builder filter(String filter) {
            return (Builder)this.setParameter("filter", filter);
        }

        public Builder format(String format) {
            return (Builder)this.setParameter("format", format);
        }

        @Override
        public Analyze build() {
            return new Analyze(this);
        }
    }
}

