/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.persistence.impl;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.hibernate.transform.ResultTransformer;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpUnicastPrefix;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpUnicastPrefixDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.PrefixByAS;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.StatsPeerRib;

public class BmpUnicastPrefixDaoImpl
extends AbstractDaoHibernate<BmpUnicastPrefix, Long>
implements BmpUnicastPrefixDao {
    public BmpUnicastPrefixDaoImpl() {
        super(BmpUnicastPrefix.class);
    }

    @Override
    public BmpUnicastPrefix findByHashId(String hashId) {
        if (Strings.isNullOrEmpty((String)hashId)) {
            return null;
        }
        Criteria criteria = new Criteria(BmpUnicastPrefix.class);
        criteria.addRestriction((Restriction)new EqRestriction("hashId", (Object)hashId));
        List bmpUnicastPrefixes = this.findMatching(criteria);
        if (bmpUnicastPrefixes != null && bmpUnicastPrefixes.size() > 0) {
            return (BmpUnicastPrefix)bmpUnicastPrefixes.get(0);
        }
        return null;
    }

    @Override
    public List<BmpUnicastPrefix> getUnicastPrefixesAfterDate(String hashId, Date time) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(BmpUnicastPrefix.class);
        criteriaBuilder.alias("bmpPeer", "bmpPeer").and(new Restriction[]{Restrictions.eq((String)"bmpPeer.hashId", (Object)hashId)}).and(new Restriction[]{Restrictions.lt((String)"bmpPeer.timeStamp", (Object)time)});
        return this.findMatching(criteriaBuilder.toCriteria());
    }

    @Override
    public List<PrefixByAS> getPrefixesGroupedByAS() {
        String query = "SELECT DISTINCT new org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.PrefixByAS( prefix.prefix, prefix.prefixLen, prefix.originAs, max(prefix.timestamp), count(prefix.bmpPeer)) FROM BmpUnicastPrefix AS prefix WHERE prefix.originAs != 0 AND prefix.originAs !=23456 AND prefix.isWithDrawn = false GROUP BY prefix.prefix,  prefix.prefixLen, prefix.originAs";
        return this.findObjects(PrefixByAS.class, query, new Object[0]);
    }

    @Override
    public List<StatsPeerRib> getPeerRibCountsByPeer() {
        return (List)this.getHibernateTemplate().execute(session -> session.createSQLQuery("SELECT to_timestamp((cast((extract(epoch from now())) as bigint)/900)*900), peer_hash_id, sum(CASE WHEN is_ipv4 = true THEN 1 ELSE 0 END) AS v4_prefixes,  sum(CASE WHEN is_ipv4 = false THEN 1 ELSE 0 END) as v6_prefixes  FROM bmp_ip_ribs  WHERE is_withdrawn = false GROUP BY peer_hash_id").setResultTransformer(new ResultTransformer(){

            public Object transformTuple(Object[] tuple, String[] aliases) {
                return new StatsPeerRib((Date)tuple[0], (String)tuple[1], (BigInteger)tuple[2], (BigInteger)tuple[3]);
            }

            public List transformList(List collection) {
                return collection;
            }
        }).list());
    }
}

