/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.IsIsElement;
import org.opennms.netmgt.enlinkd.model.IsIsElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.enlinkd.model.IsIsLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.IsIsElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.IsIsLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CompositeKey;
import org.opennms.netmgt.enlinkd.service.api.IsisTopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class IsisTopologyServiceImpl
extends TopologyServiceImpl
implements IsisTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(IsisTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private IsIsLinkDao m_isisLinkDao;
    private IsIsElementDao m_isisElementDao;

    @Override
    public void delete(int nodeid) {
        this.m_isisElementDao.deleteByNodeId(nodeid);
        this.m_isisLinkDao.deleteByNodeId(nodeid);
        this.m_isisElementDao.flush();
        this.m_isisLinkDao.flush();
    }

    @Override
    public void reconcile(int nodeId, Date now) {
        IsIsElement element = (IsIsElement)this.m_isisElementDao.findByNodeId(nodeId);
        if (element != null && element.getIsisNodeLastPollTime().getTime() < now.getTime()) {
            this.m_isisElementDao.delete(element);
            this.m_isisElementDao.flush();
        }
        this.m_isisLinkDao.deleteByNodeIdOlderThen(nodeId, now);
        this.m_isisLinkDao.flush();
    }

    @Override
    public void store(int nodeId, IsIsLink link) {
        if (link == null) {
            return;
        }
        this.saveIsisLink(nodeId, link);
        this.updatesAvailable();
    }

    @Transactional
    protected void saveIsisLink(final int nodeId, final IsIsLink saveMe) {
        new UpsertTemplate<IsIsLink, IsIsLinkDao>(this.m_transactionManager, this.m_isisLinkDao){

            @Override
            protected IsIsLink query() {
                return ((IsIsLinkDao)this.m_dao).get(nodeId, saveMe.getIsisCircIndex(), saveMe.getIsisISAdjIndex());
            }

            @Override
            protected IsIsLink doUpdate(IsIsLink dbIsIsLink) {
                dbIsIsLink.merge(saveMe);
                ((IsIsLinkDao)this.m_dao).update(dbIsIsLink);
                ((IsIsLinkDao)this.m_dao).flush();
                return dbIsIsLink;
            }

            @Override
            protected IsIsLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setIsisLinkLastPollTime(saveMe.getIsisLinkCreateTime());
                ((IsIsLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((IsIsLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, IsIsElement element) {
        if (element == null) {
            return;
        }
        IsIsElement dbelement = (IsIsElement)this.m_isisElementDao.findByNodeId(nodeId);
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_isisElementDao.saveOrUpdate(dbelement);
            this.m_isisElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setIsisNodeLastPollTime(element.getIsisNodeCreateTime());
        this.m_isisElementDao.saveOrUpdate(element);
        this.m_isisElementDao.flush();
        this.updatesAvailable();
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public IsIsElementDao getIsisElementDao() {
        return this.m_isisElementDao;
    }

    public void setIsisElementDao(IsIsElementDao isisElementDao) {
        this.m_isisElementDao = isisElementDao;
    }

    @Override
    public List<IsIsElementTopologyEntity> findAllIsIsElements() {
        return this.getTopologyEntityCache().getIsIsElementTopologyEntities();
    }

    @Override
    public List<TopologyConnection<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>> match() {
        List<IsIsElementTopologyEntity> elements = this.getTopologyEntityCache().getIsIsElementTopologyEntities();
        List<IsIsLinkTopologyEntity> allLinks = this.getTopologyEntityCache().getIsIsLinkTopologyEntities();
        HashMap<Integer, IsIsElementTopologyEntity> elementmap = new HashMap<Integer, IsIsElementTopologyEntity>();
        for (IsIsElementTopologyEntity isIsElementTopologyEntity : elements) {
            elementmap.put(isIsElementTopologyEntity.getNodeId(), isIsElementTopologyEntity);
        }
        HashMap<CompositeKey, IsIsLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, IsIsLinkTopologyEntity>();
        for (IsIsLinkTopologyEntity targetLink : allLinks) {
            IsIsElementTopologyEntity targetElement = (IsIsElementTopologyEntity)elementmap.get(targetLink.getNodeId());
            targetLinkMap.put(new CompositeKey(targetLink.getIsisISAdjIndex(), targetElement.getIsisSysID(), targetLink.getIsisISAdjNeighSysID()), targetLink);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<TopologyConnection<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>> results = new ArrayList<TopologyConnection<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>>();
        for (IsIsLinkTopologyEntity sourceLink : allLinks) {
            if (hashSet.contains(sourceLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getIsIsLinks: source: {}", (Object)sourceLink);
            }
            IsIsElementTopologyEntity sourceElement = (IsIsElementTopologyEntity)elementmap.get(sourceLink.getNodeId());
            IsIsLinkTopologyEntity targetLink = (IsIsLinkTopologyEntity)targetLinkMap.get(new CompositeKey(sourceLink.getIsisISAdjIndex(), sourceLink.getIsisISAdjNeighSysID(), sourceElement.getIsisSysID()));
            if (targetLink == null) {
                LOG.debug("getIsIsLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().intValue() == targetLink.getId().intValue() || hashSet.contains(targetLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getIsIsLinks: target: {}", (Object)targetLink);
            }
            results.add(TopologyService.of(sourceLink, targetLink));
            hashSet.add(sourceLink.getId());
            hashSet.add(targetLink.getId());
        }
        return results;
    }

    @Override
    public void deletePersistedData() {
        this.m_isisElementDao.deleteAll();
        this.m_isisElementDao.flush();
        this.m_isisLinkDao.deleteAll();
        this.m_isisLinkDao.flush();
    }
}

