/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.enlinkd.service.api.Bridge;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTable;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.springframework.util.Assert;

public class BroadcastDomain
implements Topology {
    public static final int maxlevel = 30;
    private final Set<Bridge> m_bridges = new HashSet<Bridge>();
    private final List<SharedSegment> m_topology = new ArrayList<SharedSegment>();
    private final Set<BridgePortWithMacs> m_forwarding = new HashSet<BridgePortWithMacs>();

    public void add(BridgePortWithMacs bft) {
        SharedSegment segment = new SharedSegment();
        segment.getBridgePortsOnSegment().add(bft.getPort());
        segment.getMacsOnSegment().addAll(bft.getMacs());
        segment.setDesignatedBridge(bft.getPort().getNodeId());
        this.m_topology.add(segment);
        this.cleanForwarders(bft.getMacs());
    }

    public void merge(SharedSegment upsegment, Map<BridgePortWithMacs, Set<BridgePortWithMacs>> splitted, Set<String> macsonsegment, BridgePort rootport, Set<BridgePortWithMacs> throughset) {
        Assert.notNull((Object)upsegment);
        if (!this.m_topology.contains(upsegment)) {
            return;
        }
        splitted.keySet().forEach(designated -> {
            Set ports = (Set)splitted.get(designated);
            SharedSegment splitsegment = new SharedSegment();
            splitsegment.getBridgePortsOnSegment().add(designated.getPort());
            splitsegment.setDesignatedBridge(designated.getPort().getNodeId());
            HashSet<String> macs = new HashSet<String>(designated.getMacs());
            ports.forEach(bft -> {
                macs.retainAll(bft.getMacs());
                this.cleanForwarders(bft.getPort().getNodeId());
                upsegment.getBridgePortsOnSegment().remove(bft.getPort());
                splitsegment.getBridgePortsOnSegment().add(bft.getPort());
            });
            splitsegment.getMacsOnSegment().addAll(macs);
            this.m_topology.add(splitsegment);
            this.cleanForwarders(macs);
        });
        HashMap forfpmacs = new HashMap();
        upsegment.getBridgePortsOnSegment().forEach(port -> {
            this.getForwarders(port.getNodeId()).stream().filter(forward -> forward.getPort().equals(port)).forEach(forward -> forward.getMacs().forEach(mac -> {
                int itemsfound = 1;
                if (forfpmacs.containsKey(mac)) {
                    itemsfound = (Integer)forfpmacs.get(mac);
                    ++itemsfound;
                }
                forfpmacs.put(mac, itemsfound);
            }));
            HashSet<String> clearmacs = new HashSet<String>();
            forfpmacs.keySet().forEach(mac -> {
                if (((Integer)forfpmacs.get(mac)).intValue() == upsegment.getBridgePortsOnSegment().size()) {
                    upsegment.getMacsOnSegment().add((String)mac);
                    clearmacs.add((String)mac);
                }
            });
            this.cleanForwarders(clearmacs);
        });
        upsegment.getBridgePortsOnSegment().add(rootport);
        upsegment.getMacsOnSegment().retainAll(macsonsegment);
        this.cleanForwarders(upsegment.getMacsOnSegment());
        throughset.forEach(this::add);
    }

    public void removeBridge(int bridgeId) {
        Bridge bridge = this.getBridge(bridgeId);
        if (bridge == null) {
            return;
        }
        if (this.getBridges().size() == 1) {
            this.m_topology.clear();
            this.m_bridges.clear();
            return;
        }
        this.clearTopologyForBridge(bridgeId);
        this.m_bridges.remove(bridge);
        HashSet<Bridge> bridges = new HashSet<Bridge>();
        for (Bridge cur : this.getBridges()) {
            if (cur.getNodeId() == bridgeId) continue;
            bridges.add(cur);
        }
        this.setBridges(bridges);
    }

    public void clearTopologyForBridge(Integer bridgeid) {
        Bridge bridge = this.getBridge(bridgeid);
        if (bridge == null) {
            return;
        }
        if (bridge.isNewTopology()) {
            return;
        }
        HashSet<Bridge> notnew = new HashSet<Bridge>();
        for (Bridge bridge2 : this.getBridges()) {
            if (bridge2.isNewTopology()) continue;
            notnew.add(bridge2);
        }
        if (notnew.size() == 1) {
            this.clearTopology();
            return;
        }
        SharedSegment topsegment = null;
        if (bridge.isRootBridge()) {
            for (SharedSegment segment : this.getSharedSegments(bridge.getNodeId())) {
                Bridge newRootBridge;
                Object newRootId = null;
                for (BridgePort bridgePort : segment.getBridgePortsOnSegment()) {
                    if (bridgePort == null || bridgePort.getNodeId() == null || bridgePort.getBridgePort() == null || segment.getDesignatedBridge() != null && bridgePort.getNodeId().intValue() == segment.getDesignatedBridge().intValue()) continue;
                    newRootId = bridgePort.getNodeId();
                }
                if (newRootId == null || (newRootBridge = this.getBridge((Integer)newRootId)) == null) continue;
                topsegment = this.getSharedSegment((Integer)newRootId, newRootBridge.getRootPort());
                this.hierarchySetUp(newRootBridge);
                break;
            }
        } else {
            topsegment = this.getSharedSegment(bridge.getNodeId(), bridge.getRootPort());
        }
        if (topsegment == null) {
            return;
        }
        BridgePort bridgePort = topsegment.getBridgePort(bridge.getNodeId());
        this.cleanForwarders(bridge.getNodeId());
        bridge.setRootPort(null);
        if (bridgePort == null) {
            return;
        }
        topsegment.getBridgePortsOnSegment().remove(bridgePort);
        ArrayList<SharedSegment> topology = new ArrayList<SharedSegment>();
        for (SharedSegment segment : this.getSharedSegments()) {
            if (segment.getBridgeIdsOnSegment().contains(bridge.getNodeId())) {
                for (BridgePort bridgePort2 : segment.getBridgePortsOnSegment()) {
                    if (bridgePort2.getNodeId().intValue() == bridge.getNodeId().intValue()) continue;
                    topsegment.getBridgePortsOnSegment().add(bridgePort2);
                }
                topsegment.getMacsOnSegment().addAll(segment.getMacsOnSegment());
                continue;
            }
            topology.add(segment);
        }
        this.setTopology(topology);
        HashMap forwardermap = new HashMap();
        for (BridgePortWithMacs bridgePortWithMacs : this.getForwarding()) {
            for (String mac : bridgePortWithMacs.getMacs()) {
                if (!forwardermap.containsKey(mac)) {
                    forwardermap.put(mac, new HashSet());
                }
                ((Set)forwardermap.get(mac)).add(bridgePortWithMacs.getPort());
            }
        }
        for (String string : forwardermap.keySet()) {
            SharedSegment sharedSegment = this.getSharedSegment((BridgePort)((Set)forwardermap.get(string)).iterator().next());
            if (sharedSegment == null || !((Set)forwardermap.get(string)).containsAll(sharedSegment.getBridgePortsOnSegment())) continue;
            sharedSegment.getMacsOnSegment().add(string);
        }
        this.cleanForwarders();
    }

    public boolean loadTopologyEntry(SharedSegment segment) {
        for (BridgePort port : segment.getBridgePortsOnSegment()) {
            for (Bridge bridge : this.getBridges()) {
                if (port.getNodeId().intValue() != bridge.getNodeId().intValue()) continue;
                this.getSharedSegments().add(segment);
                return true;
            }
        }
        return false;
    }

    public void hierarchySetUp(Bridge root) {
        if (root == null || this.getBridge(root.getNodeId()) == null) {
            return;
        }
        if (root.isRootBridge()) {
            return;
        }
        root.setRootBridge();
        if (this.getBridges().size() == 1) {
            return;
        }
        for (SharedSegment segment : this.getSharedSegments(root.getNodeId())) {
            segment.setDesignatedBridge(root.getNodeId());
            this.hierarchySetUpGo(segment, root.getNodeId(), 0);
        }
    }

    private void hierarchySetUpGo(SharedSegment segment, Integer rootid, int level) {
        if (segment == null) {
            return;
        }
        if (++level == 30) {
            return;
        }
        for (Integer bridgeid : segment.getBridgeIdsOnSegment()) {
            if (bridgeid.intValue() == rootid.intValue()) continue;
            Bridge bridge = this.getBridge(bridgeid);
            if (bridge == null) {
                return;
            }
            bridge.setRootPort(segment.getBridgePort(bridgeid).getBridgePort());
            for (SharedSegment s2 : this.getSharedSegments(bridgeid)) {
                if (s2.getDesignatedBridge() != null && s2.getDesignatedBridge().intValue() == rootid.intValue()) continue;
                s2.setDesignatedBridge(bridgeid);
                this.hierarchySetUpGo(s2, bridgeid, level);
            }
        }
    }

    public void addforwarders(BridgeForwardingTable bridgeFT) {
        HashSet<String> macs = new HashSet<String>(this.getMacsOnSegments());
        this.cleanForwarders(bridgeFT.getNodeId());
        for (String forward : bridgeFT.getMactoport().keySet()) {
            if (macs.contains(forward)) continue;
            this.addForwarding(bridgeFT.getMactoport().get(forward), forward);
        }
    }

    public void setBridges(Set<Bridge> bridges) {
        this.m_bridges.clear();
        this.m_bridges.addAll(bridges);
    }

    public void setTopology(List<SharedSegment> topology) {
        this.m_topology.clear();
        this.m_topology.addAll(topology);
    }

    public void cleanForwarders() {
        this.cleanForwarders(this.getMacsOnSegments());
    }

    public void cleanForwarders(Set<String> macs) {
        this.m_forwarding.forEach(bpm -> bpm.getMacs().removeAll(macs));
    }

    public void addForwarding(BridgePort forwardport, String forwardmac) {
        for (BridgePortWithMacs bpm : this.m_forwarding) {
            if (!bpm.getPort().equals(forwardport)) continue;
            bpm.getMacs().add(forwardmac);
            return;
        }
        BridgePortWithMacs bpm = new BridgePortWithMacs(forwardport, new HashSet<String>());
        bpm.getMacs().add(forwardmac);
        this.m_forwarding.add(bpm);
    }

    public void setForwarders(Set<BridgePortWithMacs> forwarders) {
        this.m_forwarding.addAll(forwarders);
    }

    public Set<BridgePortWithMacs> getForwarding() {
        return this.m_forwarding;
    }

    public Set<BridgePortWithMacs> getForwarders(Integer bridgeId) {
        HashSet<BridgePortWithMacs> bridgeforwarders = new HashSet<BridgePortWithMacs>();
        this.m_forwarding.stream().filter(bfm -> Objects.equals(bfm.getPort().getNodeId(), bridgeId)).forEach(bridgeforwarders::add);
        return bridgeforwarders;
    }

    public void cleanForwarders(Integer bridgeId) {
        Set<BridgePortWithMacs> bridgeforwarders = this.getForwarders(bridgeId);
        this.m_forwarding.removeAll(bridgeforwarders);
    }

    public void clearTopology() {
        this.m_topology.clear();
        this.m_forwarding.clear();
        for (Bridge bridge : this.m_bridges) {
            bridge.setRootPort(null);
        }
    }

    public boolean isEmpty() {
        return this.m_bridges.isEmpty();
    }

    public Set<Integer> getBridgeNodesOnDomain() {
        HashSet<Integer> bridgeIds = new HashSet<Integer>();
        for (Bridge bridge : this.m_bridges) {
            bridgeIds.add(bridge.getNodeId());
        }
        return bridgeIds;
    }

    public Set<Bridge> getBridges() {
        return this.m_bridges;
    }

    public List<SharedSegment> getSharedSegments() {
        return this.m_topology;
    }

    public Bridge getRootBridge() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return bridge;
        }
        return null;
    }

    public Bridge getBridge(int bridgeId) {
        for (Bridge bridge : this.m_bridges) {
            if (bridge.getNodeId() != bridgeId) continue;
            return bridge;
        }
        return null;
    }

    public Set<String> getMacsOnSegments() {
        HashSet<String> macs = new HashSet<String>();
        for (SharedSegment segment : this.m_topology) {
            macs.addAll(segment.getMacsOnSegment());
        }
        return macs;
    }

    public List<SharedSegment> getSharedSegments(Integer bridgeId) {
        ArrayList<SharedSegment> segmentsOnBridge = new ArrayList<SharedSegment>();
        for (SharedSegment segment : this.m_topology) {
            if (!segment.getBridgeIdsOnSegment().contains(bridgeId)) continue;
            segmentsOnBridge.add(segment);
        }
        return segmentsOnBridge;
    }

    public Set<Bridge> getBridgeOnSharedSegment(SharedSegment segment) {
        HashSet<Integer> nodeidsOnSegment = new HashSet<Integer>(segment.getBridgeIdsOnSegment());
        HashSet<Bridge> bridgesOn = new HashSet<Bridge>();
        for (Bridge bridge : this.m_bridges) {
            if (!nodeidsOnSegment.contains(bridge.getNodeId())) continue;
            bridgesOn.add(bridge);
        }
        return bridgesOn;
    }

    public SharedSegment getSharedSegment(Integer bridgeid, Integer bridgePort) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(bridgeid);
        bp.setBridgePort(bridgePort);
        return this.getSharedSegment(bp);
    }

    public SharedSegment getSharedSegment(BridgePort bridgePort) {
        if (bridgePort == null) {
            return null;
        }
        for (SharedSegment segment : this.m_topology) {
            if (!segment.getBridgePortsOnSegment().contains(bridgePort)) continue;
            return segment;
        }
        return null;
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("<--- broadcast domain ....-----");
        this.getBridges().forEach(bridge -> {
            strbfr.append("\n");
            strbfr.append(bridge.printTopology());
        });
        Bridge rootBridge = this.getRootBridge();
        if (rootBridge != null && !this.m_topology.isEmpty()) {
            HashSet<Integer> rootids = new HashSet<Integer>();
            rootids.add(rootBridge.getNodeId());
            strbfr.append(this.printTopologyFromLevel(rootids, 0));
        } else {
            this.m_topology.forEach(shared -> strbfr.append(shared.printTopology()));
        }
        strbfr.append("\n----forwarders----");
        this.m_forwarding.forEach(bfte -> {
            strbfr.append("\nforward -> ");
            strbfr.append(bfte.printTopology());
        });
        strbfr.append("\n.... broadcast domain .....--->");
        return strbfr.toString();
    }

    public String printTopologyFromLevel(Set<Integer> bridgeIds, int level) {
        HashSet<Integer> bridgesDownLevel = new HashSet<Integer>();
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("\n------level ");
        strbfr.append(level);
        strbfr.append(" -----\n");
        strbfr.append("bridges on level:");
        strbfr.append(bridgeIds);
        bridgeIds.stream().map(this::getBridge).filter(Objects::nonNull).forEach(bridge -> {
            for (SharedSegment segment : this.getSharedSegments(bridge.getNodeId())) {
                if (segment.getDesignatedBridge().intValue() != bridge.getNodeId().intValue()) continue;
                strbfr.append("\n");
                strbfr.append(segment.printTopology());
                bridgesDownLevel.addAll(segment.getBridgeIdsOnSegment());
            }
        });
        bridgesDownLevel.removeAll(bridgeIds);
        if (!bridgesDownLevel.isEmpty()) {
            strbfr.append(this.printTopologyFromLevel(bridgesDownLevel, level + 1));
        }
        return strbfr.toString();
    }
}

