/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceWalker;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceVisitor;
import org.springframework.util.Assert;

public class ResourceTreeWalker
implements ResourceWalker {
    private ResourceDao m_resourceDao;
    private ResourceVisitor m_visitor;

    @Override
    public void walk() {
        this.walk(this.m_resourceDao.findTopLevelResources());
    }

    public void walk(Collection<OnmsResource> resources) {
        for (OnmsResource resource : resources) {
            this.m_visitor.visit(resource);
            this.walk(resource.getChildResources());
        }
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
        Assert.state((this.m_visitor != null ? 1 : 0) != 0, (String)"property visitor must be set to a non-null value");
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    @Override
    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public ResourceVisitor getVisitor() {
        return this.m_visitor;
    }

    @Override
    public void setVisitor(ResourceVisitor visitor) {
        this.m_visitor = visitor;
    }
}

