/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.EventConfSourceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.EventConfSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfSourceDaoHibernate
extends AbstractDaoHibernate<EventConfSource, Long>
implements EventConfSourceDao {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfSourceDaoHibernate.class);

    public EventConfSourceDaoHibernate() {
        super(EventConfSource.class);
    }

    @Override
    public EventConfSource get(Long id) {
        return (EventConfSource)super.get(id);
    }

    @Override
    public EventConfSource findByName(String name) {
        List list = this.find("from EventConfSource s where s.name = ?", name);
        return list.isEmpty() ? null : (EventConfSource)list.get(0);
    }

    @Override
    public List<EventConfSource> findAllEnabled() {
        return this.find("from EventConfSource s where s.enabled = true order by s.fileOrder");
    }

    @Override
    public List<EventConfSource> findByVendor(String vendor) {
        return this.find("from EventConfSource s where s.vendor = ?", vendor);
    }

    @Override
    public List<EventConfSource> findAllByFileOrder() {
        return this.find("from EventConfSource s order by s.fileOrder");
    }

    @Override
    public Map<Long, String> getIdToNameMap() {
        return this.findObjects(Object[].class, "select s.id, s.name from EventConfSource s", new Object[0]).stream().collect(Collectors.toMap(row -> (Long)row[0], row -> (String)row[1]));
    }

    @Override
    public void deleteAll(Collection<EventConfSource> list) {
        super.deleteAll(list);
    }

    @Override
    public void updateEnabledFlag(Collection<Long> sourceIds, boolean enabled, boolean cascadeToEvents) {
        if (sourceIds == null || sourceIds.isEmpty()) {
            return;
        }
        String hqlSource = "update EventConfSource s set s.enabled = :enabled where s.id in (:ids)";
        this.getSessionFactory().getCurrentSession().createQuery(hqlSource).setParameter("enabled", (Object)enabled).setParameterList("ids", sourceIds).executeUpdate();
        if (cascadeToEvents) {
            String hqlEvents = "update EventConfEvent e set e.enabled = :enabled where e.source.id in (:ids)";
            this.getSessionFactory().getCurrentSession().createQuery(hqlEvents).setParameter("enabled", (Object)enabled).setParameterList("ids", sourceIds).executeUpdate();
        }
        LOG.info("Set enabled={} for sources {} (cascadeToEvents={})", new Object[]{enabled, sourceIds, cascadeToEvents});
    }

    @Override
    public Map<String, Object> filterEventConfSource(String filter, String sortBy, String order, Integer totalRecords, Integer offset, Integer limit) {
        int resultCount = totalRecords != null ? totalRecords : 0;
        List eventConfSourceList = Collections.emptyList();
        try {
            String whereClause;
            ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
            ArrayList<String> conditions = new ArrayList<String>();
            if (filter != null && !filter.trim().isEmpty()) {
                String escapedFilter = "%" + this.escapeLike(filter.trim().toLowerCase()) + "%";
                conditions.add("lower(s.name) like ? escape '\\'");
                queryParams.add((CallSite)((Object)escapedFilter));
                conditions.add("lower(s.vendor) like ? escape '\\'");
                queryParams.add((CallSite)((Object)escapedFilter));
                conditions.add("lower(s.description) like ? escape '\\'");
                queryParams.add((CallSite)((Object)escapedFilter));
                conditions.add("exists (select 1 from EventConfEvent e where e.source = s and lower(e.uei) like ? escape '\\')");
                queryParams.add((CallSite)((Object)escapedFilter));
                conditions.add("exists (select 1 from EventConfEvent e where e.source = s and lower(e.eventLabel) like ? escape '\\')");
                queryParams.add((CallSite)((Object)escapedFilter));
            }
            String string = whereClause = conditions.isEmpty() ? "" : " where " + String.join((CharSequence)" OR ", conditions);
            if (resultCount == 0) {
                String countQuery = "select count(s.id) from EventConfSource s " + whereClause;
                resultCount = super.queryInt(countQuery, queryParams.toArray());
            }
            if (resultCount > 0) {
                Object orderBy = "";
                String sortField = sortBy;
                String sortOrder = "ASC".equalsIgnoreCase(order) ? "ASC" : "DESC";
                Set<String> allowedSortFields = Set.of("name", "vendor", "description", "fileOrder", "eventCount");
                if (!allowedSortFields.contains(sortBy)) {
                    sortField = "createdTime";
                }
                orderBy = " order by " + sortField + " " + sortOrder;
                String dataQuery = "from EventConfSource s " + whereClause + (String)orderBy;
                eventConfSourceList = this.findWithPagination(dataQuery, queryParams.toArray(), offset, limit);
            }
        }
        catch (Exception e) {
            LOG.debug("Error filterEventConfSource method while fetching the records {} ", (Throwable)e);
        }
        return Map.of("totalRecords", resultCount, "eventConfSourceList", eventConfSourceList);
    }

    @Override
    public Integer findMaxFileOrder() {
        Integer maxOrder = (Integer)this.getSessionFactory().getCurrentSession().createQuery("SELECT MAX(e.fileOrder) FROM EventConfSource e").uniqueResult();
        return maxOrder != null ? maxOrder : 0;
    }

    @Override
    public List<String> findAllVendors() {
        return this.findObjects(String.class, "select distinct s.vendor from EventConfSource s", new Object[0]);
    }

    @Override
    public void deleteBySourceIds(List<Long> sourceIds) {
        int deletedCount = (Integer)this.getHibernateTemplate().execute(session -> session.createQuery("delete from EventConfSource s where s.id in (:ids)").setParameterList("ids", (Collection)sourceIds).executeUpdate());
        LOG.info("Deleted {} EventConfSource(s) with IDs: {}", (Object)deletedCount, sourceIds);
    }

    @Override
    public List<String> findAllNames() {
        return this.findObjects(String.class, "select distinct s.name from EventConfSource s ", new Object[0]);
    }

    @Override
    public void saveOrUpdate(EventConfSource source) {
        super.saveOrUpdate(source);
    }

    @Override
    public void delete(EventConfSource source) {
        super.delete(source);
    }

    private String escapeLike(String input) {
        return input.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_").replace("@", "\\@").replace("/", "\\/").replace("[", "\\[").replace("]", "\\]").replace(".", "\\.");
    }
}

