/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.springframework.dao.DataAccessException;

public abstract class AbstractCachingDaoHibernate<T, DbKey extends Serializable, CacheKey>
extends AbstractDaoHibernate<T, DbKey> {
    private final ThreadLocal<HashMap<CacheKey, T>> m_cache = new ThreadLocal();
    private final boolean m_dbKeyMatchesCacheKey;

    public AbstractCachingDaoHibernate(Class<T> entityClass, boolean dbKeyMatchesCacheKey) {
        super(entityClass);
        this.m_dbKeyMatchesCacheKey = dbKeyMatchesCacheKey;
    }

    protected abstract CacheKey getKey(T var1);

    @Override
    public void clear() {
        this.m_cache.remove();
        super.clear();
    }

    @Override
    public void deleteAll(Collection<T> entities) throws DataAccessException {
        List ids = Collections.emptyList();
        if (this.m_cache.get() != null) {
            ids = new ArrayList(entities.size());
            for (T t : entities) {
                ids.add(this.getKey(t));
            }
        }
        super.deleteAll(entities);
        if (this.m_cache.get() != null) {
            for (T id : ids) {
                this.m_cache.get().remove(id);
            }
        }
    }

    @Override
    public void delete(T entity) throws DataAccessException {
        CacheKey id = this.getKey(entity);
        super.delete(entity);
        if (this.m_cache.get() != null) {
            this.m_cache.get().remove(id);
        }
    }

    @Override
    public List<T> findAll() throws DataAccessException {
        List entities = super.findAll();
        HashMap map = new HashMap();
        for (Object t : entities) {
            map.put(this.getKey(t), t);
        }
        this.m_cache.set(map);
        return entities;
    }

    @Override
    public T get(DbKey id) throws DataAccessException {
        Object t;
        if (this.m_cache.get() == null) {
            this.m_cache.set(new HashMap());
        }
        if (this.m_dbKeyMatchesCacheKey && (t = this.m_cache.get().get(id)) != null) {
            return t;
        }
        t = super.get(id);
        if (t != null) {
            this.m_cache.get().put(this.getKey(t), t);
        }
        return t;
    }

    @Override
    public T load(DbKey id) throws DataAccessException {
        Object t;
        if (this.m_cache.get() == null) {
            this.m_cache.set(new HashMap());
        }
        if (this.m_dbKeyMatchesCacheKey && (t = this.m_cache.get().get(id)) != null) {
            return t;
        }
        t = super.load(id);
        if (t != null) {
            this.m_cache.get().put(this.getKey(t), t);
        }
        return t;
    }

    @Override
    public void merge(T entity) {
        super.merge(entity);
        if (this.m_cache.get() != null) {
            this.m_cache.get().put(this.getKey(entity), entity);
        }
    }

    @Override
    public DbKey save(T entity) throws DataAccessException {
        Object retval = super.save(entity);
        if (this.m_cache.get() != null) {
            this.m_cache.get().put(this.getKey(entity), entity);
        }
        return (DbKey)retval;
    }

    @Override
    public void saveOrUpdate(T entity) throws DataAccessException {
        super.saveOrUpdate(entity);
        if (this.m_cache.get() != null) {
            this.m_cache.get().put(this.getKey(entity), entity);
        }
    }

    @Override
    public void update(T entity) throws DataAccessException {
        super.update(entity);
        if (this.m_cache.get() != null) {
            this.m_cache.get().put(this.getKey(entity), entity);
        }
    }

    protected T findByCacheKey(String queryString, CacheKey key) {
        Object t = null;
        if (this.m_cache.get() != null && (t = (Object)this.m_cache.get().get(key)) != null) {
            return (T)t;
        }
        t = this.findUnique(queryString, key);
        if (t != null) {
            if (this.m_cache.get() == null) {
                this.m_cache.set(new HashMap());
            }
            this.m_cache.get().put(key, t);
        }
        return (T)t;
    }
}

