/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.openconfig.telemetry;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.core.grpc.common.GrpcClientBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.StringUtils;
import org.opennms.features.openconfig.api.OpenConfigClient;
import org.opennms.features.openconfig.proto.gnmi.Gnmi;
import org.opennms.features.openconfig.proto.gnmi.gNMIGrpc;
import org.opennms.features.openconfig.proto.jti.OpenConfigTelemetryGrpc;
import org.opennms.features.openconfig.proto.jti.Telemetry;
import org.opennms.features.openconfig.telemetry.GrpcClientInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenConfigClientImpl
implements OpenConfigClient {
    private static final Logger LOG = LoggerFactory.getLogger(OpenConfigClientImpl.class);
    private static final Pattern STRINGS_IN_SQUARE_BRACKETS = Pattern.compile("\\[(.+?=.+?)\\]");
    private static final Pattern PATH_SEPARATOR = Pattern.compile("\\/(?![^\\[]*])");
    private static final int DEFAULT_INTERNAL_RETRIES = 5;
    private static final int DEFAULT_INTERNAL_TIMEOUT = 1000;
    private static final int DEFAULT_FREQUENCY = 300000;
    private static final long DEFAULT_FREQUENCY_FOR_GNMI = 300000000000L;
    private static final int DEFAULT_INTERVAL_IN_SEC = 300;
    private static final String PORT = "port";
    private static final String HOSTNAME = "hostname";
    private static final String MODE = "mode";
    private static final String PATHS = "paths";
    private static final String FREQUENCY = "frequency";
    private static final String INTERVAL = "interval";
    private static final String RETRIES = "retries";
    private static final String JTI_MODE = "jti";
    private static final String ORIGIN = "origin";
    private static final String DEFAULT_ORIGIN = "openconfig";
    private static final String USERNAME_FIELD = "username";
    private static final String PASSWORD_FIELD = "password";
    private ManagedChannel channel;
    private final InetAddress host;
    private String hostName;
    private Integer port;
    private String mode;
    private Integer interval;
    private Integer retries;
    private List<Map<String, String>> paramList = new ArrayList<Map<String, String>>();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean scheduled = new AtomicBoolean(false);
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    public OpenConfigClientImpl(InetAddress host, List<Map<String, String>> paramList) {
        this.host = Objects.requireNonNull(host);
        this.paramList.addAll(paramList);
        this.paramList.stream().filter(entry -> entry.containsKey(PORT) && entry.get(PORT) != null).findFirst().ifPresent(entry -> {
            this.port = StringUtils.parseInt((String)((String)entry.get(PORT)), null);
        });
        this.paramList.stream().filter(entry -> entry.get(MODE) != null).findFirst().ifPresent(entry -> {
            this.mode = (String)entry.get(MODE);
        });
        this.paramList.stream().filter(entry -> entry.containsKey(HOSTNAME) && entry.get(HOSTNAME) != null).findFirst().ifPresent(entry -> {
            this.hostName = (String)entry.get(HOSTNAME);
        });
    }

    public void subscribe(OpenConfigClient.Handler handler) {
        boolean succeeded = this.trySubscribing(handler);
        if (!succeeded) {
            this.close();
            this.executor.execute(() -> this.scheduleSubscription(handler));
        }
    }

    private boolean trySubscribing(OpenConfigClient.Handler handler) {
        try {
            HashMap tlsFilePaths = new HashMap();
            this.paramList.forEach(entry -> tlsFilePaths.putAll(entry.entrySet().stream().filter(configuration -> ((String)configuration.getKey()).contains("tls")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
            String host = this.hostName != null ? this.hostName : this.host.getHostAddress();
            Optional<Map> optionalUsername = this.paramList.stream().filter(entry -> entry.get(USERNAME_FIELD) != null).findFirst();
            Optional<Map> optionalPassword = this.paramList.stream().filter(entry -> entry.get(PASSWORD_FIELD) != null).findFirst();
            if (optionalUsername.isPresent() && optionalPassword.isPresent()) {
                String username = (String)optionalUsername.get().get(USERNAME_FIELD);
                String password = (String)optionalPassword.get().get(PASSWORD_FIELD);
                Metadata metadata = new Metadata();
                metadata.put(Metadata.Key.of((String)USERNAME_FIELD, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)username);
                metadata.put(Metadata.Key.of((String)PASSWORD_FIELD, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)password);
                GrpcClientInterceptor clientInterceptor = new GrpcClientInterceptor(metadata);
                this.channel = GrpcClientBuilder.getChannelWithInterceptor((String)host, (int)this.port, tlsFilePaths, (ClientInterceptor)clientInterceptor);
            } else {
                this.channel = GrpcClientBuilder.getChannel((String)host, (int)this.port, tlsFilePaths);
            }
            if (ConnectivityState.READY.equals((Object)this.retrieveChannelState())) {
                this.subscribeToTelemetry(handler, host);
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while subscribing to OpenConfig Server at `{}` ", (Object)InetAddressUtils.str((InetAddress)this.host), (Object)e);
        }
        return false;
    }

    private void subscribeToTelemetry(OpenConfigClient.Handler handler, String host) {
        if (JTI_MODE.equalsIgnoreCase(this.mode)) {
            OpenConfigTelemetryGrpc.OpenConfigTelemetryStub asyncStub = OpenConfigTelemetryGrpc.newStub((Channel)this.channel);
            Telemetry.SubscriptionRequest.Builder requestBuilder = Telemetry.SubscriptionRequest.newBuilder();
            this.paramList.forEach(entry -> {
                Integer frequency = StringUtils.parseInt((String)((String)entry.get(FREQUENCY)), (Integer)300000);
                String pathString = (String)entry.get(PATHS);
                ArrayList paths = pathString != null ? Arrays.asList(pathString.split(",", -1)) : new ArrayList();
                paths.forEach(path -> requestBuilder.addPathList(Telemetry.Path.newBuilder().setPath(path).setSampleFrequency(frequency.intValue()).build()));
            });
            asyncStub.telemetrySubscribe(requestBuilder.build(), (StreamObserver)new TelemetryDataHandler(this.host, this.port, handler));
            LOG.info("Subscribed to OpenConfig telemetry stream at {}:{}", (Object)host, (Object)this.port);
        } else {
            gNMIGrpc.gNMIStub gNMIStub2 = gNMIGrpc.newStub((Channel)this.channel);
            Gnmi.SubscribeRequest.Builder requestBuilder = Gnmi.SubscribeRequest.newBuilder();
            Gnmi.SubscriptionList.Builder subscriptionListBuilder = Gnmi.SubscriptionList.newBuilder();
            this.paramList.forEach(entry -> {
                Long frequency = StringUtils.parseLong((String)((String)entry.get(FREQUENCY)), (Long)300000000000L);
                String pathString = (String)entry.get(PATHS);
                String origin = (String)entry.get(ORIGIN);
                ArrayList paths = pathString != null ? Arrays.asList(pathString.split(",", -1)) : new ArrayList();
                paths.forEach(path -> {
                    Gnmi.Path gnmiPath = OpenConfigClientImpl.buildGnmiPath(path, origin);
                    Gnmi.Subscription subscription = Gnmi.Subscription.newBuilder().setPath(gnmiPath).setSampleInterval(frequency.longValue()).setMode(Gnmi.SubscriptionMode.SAMPLE).build();
                    subscriptionListBuilder.addSubscription(subscription);
                    subscriptionListBuilder.setMode(Gnmi.SubscriptionList.Mode.STREAM);
                });
            });
            requestBuilder.setSubscribe(subscriptionListBuilder.build());
            StreamObserver requestStreamObserver = gNMIStub2.subscribe((StreamObserver)new GnmiDataHandler(handler, this.host, this.port));
            requestStreamObserver.onNext((Object)requestBuilder.build());
            LOG.info("Subscribed to OpenConfig telemetry stream at {}:{}", (Object)host, (Object)this.port);
        }
    }

    static Gnmi.Path buildGnmiPath(String path, String origin) {
        Gnmi.Path.Builder gnmiPathBuilder = Gnmi.Path.newBuilder();
        List elemList = Splitter.on((Pattern)PATH_SEPARATOR).omitEmptyStrings().splitToList((CharSequence)path);
        elemList.forEach(elem -> {
            if (elem.contains("[")) {
                String name = elem.substring(0, elem.indexOf("["));
                Map<String, String> keyValues = OpenConfigClientImpl.getPathElemParam(elem);
                Gnmi.PathElem.Builder builder = Gnmi.PathElem.newBuilder();
                builder.setName(name);
                keyValues.forEach((arg_0, arg_1) -> ((Gnmi.PathElem.Builder)builder).putKey(arg_0, arg_1));
                gnmiPathBuilder.addElem(builder.build());
            } else {
                gnmiPathBuilder.addElem(Gnmi.PathElem.newBuilder().setName(elem).build());
            }
        });
        if (Strings.isNullOrEmpty((String)origin)) {
            gnmiPathBuilder.setOrigin(DEFAULT_ORIGIN);
        } else {
            gnmiPathBuilder.setOrigin(origin);
        }
        return gnmiPathBuilder.build();
    }

    private static Map<String, String> getPathElemParam(String element) {
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = STRINGS_IN_SQUARE_BRACKETS.matcher(element);
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        matches.forEach(match -> {
            String[] keyValues = match.split("=", 2);
            params.put(keyValues[0], keyValues[1]);
        });
        return params;
    }

    private void scheduleSubscription(OpenConfigClient.Handler handler) {
        int interval;
        if (this.scheduled.get()) {
            return;
        }
        this.scheduled.set(true);
        boolean succeeded = this.trySubscribing(handler);
        if (succeeded) {
            this.scheduled.set(false);
            return;
        }
        this.paramList.stream().filter(entry -> entry.containsKey(INTERVAL) && entry.get(INTERVAL) != null).findFirst().ifPresent(entry -> {
            this.interval = StringUtils.parseInt((String)((String)entry.get(INTERVAL)), (Integer)300);
        });
        this.paramList.stream().filter(entry -> entry.containsKey(RETRIES) && entry.get(RETRIES) != null).findFirst().ifPresent(entry -> {
            this.retries = StringUtils.parseInt((String)((String)entry.get(RETRIES)), (Integer)5);
        });
        int retries = this.retries != null ? this.retries : 5;
        int n = interval = this.interval != null ? this.interval : 300;
        while (!this.closed.get()) {
            ScheduledFuture<Boolean> future = this.scheduledExecutor.schedule(() -> this.trySubscribing(handler), (long)interval, TimeUnit.SECONDS);
            try {
                succeeded = (Boolean)future.get();
                if (succeeded) {
                    this.scheduled.set(false);
                    break;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Exception while scheduling subscription at host `{}` ", (Object)InetAddressUtils.str((InetAddress)this.host), (Object)e);
            }
            if (retries <= 0 || --retries != 0) continue;
            this.scheduled.set(false);
            break;
        }
    }

    public void shutdown() {
        this.close();
        this.closed.set(true);
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private void close() {
        if (this.channel != null) {
            LOG.info("Closing the OpenConfig Client at {}", (Object)this.host);
            this.channel.shutdown();
        }
    }

    private ConnectivityState retrieveChannelState() {
        ConnectivityState state = null;
        for (int retries = 5; retries > 0 && !this.closed.get() && !(state = this.channel.getState(true)).equals((Object)ConnectivityState.READY); --retries) {
            LOG.warn("OpenConfig Server at `{}` is not in ready state, current state {}, retrying..", (Object)InetAddressUtils.str((InetAddress)this.host), (Object)state);
            this.waitBeforeRetrying(1000L);
        }
        return state;
    }

    private void waitBeforeRetrying(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            LOG.warn("Sleep was interrupted", (Throwable)e);
        }
    }

    private class TelemetryDataHandler
    implements StreamObserver<Telemetry.OpenConfigData> {
        private final OpenConfigClient.Handler handler;
        private final InetAddress host;
        private final Integer port;

        private TelemetryDataHandler(InetAddress host, Integer port, OpenConfigClient.Handler handler) {
            this.host = host;
            this.port = port;
            this.handler = handler;
        }

        public void onNext(Telemetry.OpenConfigData value) {
            if (!OpenConfigClientImpl.this.closed.get()) {
                this.handler.accept(this.host, this.port, value.toByteArray());
            }
        }

        public void onError(Throwable t) {
            LOG.error("Received error on stream for host {}", (Object)InetAddressUtils.str((InetAddress)this.host), (Object)t);
            this.handler.onError(t.getMessage());
            OpenConfigClientImpl.this.close();
            if (!OpenConfigClientImpl.this.closed.get()) {
                OpenConfigClientImpl.this.executor.execute(() -> OpenConfigClientImpl.this.scheduleSubscription(this.handler));
            }
        }

        public void onCompleted() {
            LOG.info("Response stream closed for host {}", (Object)InetAddressUtils.str((InetAddress)this.host));
            this.handler.onError("OpenConfig Server closed connection for host " + InetAddressUtils.str((InetAddress)this.host));
            OpenConfigClientImpl.this.close();
            if (!OpenConfigClientImpl.this.closed.get()) {
                OpenConfigClientImpl.this.executor.execute(() -> OpenConfigClientImpl.this.scheduleSubscription(this.handler));
            }
        }
    }

    private class GnmiDataHandler
    implements StreamObserver<Gnmi.SubscribeResponse> {
        private final OpenConfigClient.Handler handler;
        private final InetAddress host;
        private final Integer port;

        public GnmiDataHandler(OpenConfigClient.Handler handler, InetAddress host, Integer port) {
            this.handler = handler;
            this.host = host;
            this.port = port;
        }

        public void onNext(Gnmi.SubscribeResponse subscribeResponse) {
            if (subscribeResponse != null && !OpenConfigClientImpl.this.closed.get()) {
                this.handler.accept(this.host, this.port, subscribeResponse.toByteArray());
            }
        }

        public void onError(Throwable t) {
            LOG.error("Received error on stream for host {}", (Object)InetAddressUtils.str((InetAddress)this.host), (Object)t);
            this.handler.onError(t.getMessage());
            OpenConfigClientImpl.this.close();
            if (!OpenConfigClientImpl.this.closed.get()) {
                OpenConfigClientImpl.this.executor.execute(() -> OpenConfigClientImpl.this.scheduleSubscription(this.handler));
            }
        }

        public void onCompleted() {
            LOG.info("Response stream closed for host {}", (Object)InetAddressUtils.str((InetAddress)this.host));
            this.handler.onError("OpenConfig Server closed connection for host " + InetAddressUtils.str((InetAddress)this.host));
            OpenConfigClientImpl.this.close();
            if (!OpenConfigClientImpl.this.closed.get()) {
                OpenConfigClientImpl.this.executor.execute(() -> OpenConfigClientImpl.this.scheduleSubscription(this.handler));
            }
        }
    }
}

