/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Snmp4JAgentConfig {
    private SnmpAgentConfig m_config;

    public Snmp4JAgentConfig(SnmpAgentConfig config) {
        this.m_config = config;
    }

    public InetAddress getInetAddress() {
        return this.m_config.getAddress();
    }

    public OctetString getAuthPassPhrase() {
        return Snmp4JAgentConfig.createOctetString(this.m_config.getAuthPassPhrase());
    }

    public OID getAuthProtocol() {
        return Snmp4JAgentConfig.convertAuthProtocol(this.m_config.getAuthProtocol());
    }

    public int getMaxRequestSize() {
        return this.m_config.getMaxRequestSize();
    }

    public int getMaxVarsPerPdu() {
        return this.m_config.getMaxVarsPerPdu();
    }

    public int getMaxRepetitions() {
        return this.m_config.getMaxRepetitions();
    }

    public int getPort() {
        return this.m_config.getPort();
    }

    public int getRetries() {
        return this.m_config.getRetries();
    }

    public int getSecurityLevel() {
        return this.convertSecurityLevel(this.m_config.getSecurityLevel());
    }

    public OctetString getSecurityName() {
        return this.convertSecurityName(this.m_config.getSecurityName());
    }

    public int getTimeout() {
        return this.m_config.getTimeout();
    }

    public int getVersion() {
        return this.convertVersion(this.m_config.getVersion());
    }

    public String getVersionString() {
        switch (this.getVersion()) {
            case 0: {
                return "SNMPv1";
            }
            case 1: {
                return "SNMPv2c";
            }
            case 3: {
                return "SNMPv3";
            }
        }
        return "unknown: " + this.getVersion();
    }

    public OctetString getWriteCommunity() {
        return Snmp4JAgentConfig.convertCommunity(this.m_config.getWriteCommunity());
    }

    public String toString() {
        return this.m_config.toString();
    }

    public static Address convertAddress(InetAddress address, int port) {
        Object transportAddress = address.getHostAddress();
        transportAddress = (String)transportAddress + "/" + port;
        return new UdpAddress((String)transportAddress);
    }

    private int convertVersion(int version) {
        switch (version) {
            case 3: {
                return 3;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static OctetString createOctetString(String s) {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString(s.substring(2), ':') : new OctetString(s);
        return octetString;
    }

    private OctetString convertSecurityName(String securityName) {
        return new OctetString(securityName);
    }

    private OID convertPrivProtocol(String privProtocol) {
        if (StringUtils.isBlank((String)privProtocol)) {
            return null;
        }
        if (privProtocol.equals("DES")) {
            return PrivDES.ID;
        }
        if (privProtocol.equals("AES128") || privProtocol.equals("AES")) {
            return PrivAES128.ID;
        }
        if (privProtocol.equals("AES192")) {
            return PrivAES192.ID;
        }
        if (privProtocol.equals("AES256")) {
            return PrivAES256.ID;
        }
        throw new IllegalArgumentException("Privacy protocol " + privProtocol + " not supported");
    }

    private static OctetString convertCommunity(String community) {
        return new OctetString(community);
    }

    private static OID convertAuthProtocol(String authProtocol) {
        if (StringUtils.isBlank((String)authProtocol)) {
            return null;
        }
        switch (authProtocol) {
            case "MD5": {
                return AuthMD5.ID;
            }
            case "SHA": {
                return AuthSHA.ID;
            }
            case "SHA-224": {
                return AuthHMAC128SHA224.ID;
            }
            case "SHA-256": {
                return AuthHMAC192SHA256.ID;
            }
            case "SHA-512": {
                return AuthHMAC384SHA512.ID;
            }
        }
        throw new IllegalArgumentException("Authentication protocol unsupported: " + authProtocol);
    }

    @VisibleForTesting
    public Target getTarget() {
        return this.getTarget(false);
    }

    public Target getTarget(boolean useWriteCommunity) {
        Target target = this.createTarget(useWriteCommunity);
        target.setVersion(this.getVersion());
        target.setRetries(this.getRetries());
        target.setTimeout(this.getTimeout());
        target.setAddress(this.getAddress());
        target.setMaxSizeRequestPDU(this.getMaxRequestSize());
        return target;
    }

    private Target createTarget(boolean useWriteCommunity) {
        return this.isSnmpV3() ? this.createUserTarget() : this.createCommunityTarget(useWriteCommunity);
    }

    boolean isSnmpV3() {
        return this.m_config.getVersion() == 3;
    }

    private Target createCommunityTarget(boolean useWriteCommunity) {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(useWriteCommunity ? this.getWriteCommunity() : this.getReadCommunity());
        return target;
    }

    private Target createUserTarget() {
        UserTarget target = new UserTarget();
        target.setSecurityLevel(this.getSecurityLevel());
        target.setSecurityName(this.getSecurityName());
        return target;
    }

    private OctetString getReadCommunity() {
        return Snmp4JAgentConfig.convertCommunity(this.m_config.getReadCommunity());
    }

    private Address getAddress() {
        return Snmp4JAgentConfig.convertAddress(this.getInetAddress(), this.getPort());
    }

    public OID getPrivProtocol() {
        return this.convertPrivProtocol(this.m_config.getPrivProtocol());
    }

    public OctetString getPrivPassPhrase() {
        return Snmp4JAgentConfig.createOctetString(this.m_config.getPrivPassPhrase());
    }

    public OctetString getContextName() {
        return Snmp4JAgentConfig.createOctetString(this.m_config.getContextName());
    }

    public OctetString getContextEngineID() {
        return Snmp4JAgentConfig.createOctetString(this.m_config.getContextEngineId());
    }

    private int convertSecurityLevel(int securityLevel) {
        switch (securityLevel) {
            case 2: {
                securityLevel = 2;
                break;
            }
            case 3: {
                securityLevel = 3;
                break;
            }
            case 1: {
                securityLevel = 1;
                break;
            }
            default: {
                securityLevel = 1;
            }
        }
        return securityLevel;
    }

    public Snmp createSnmpSession() throws IOException {
        Snmp session;
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        MessageDispatcherImpl disp = new MessageDispatcherImpl();
        if (!this.isSnmpV3()) {
            disp.addMessageProcessingModel(new MPv1());
            disp.addMessageProcessingModel(new MPv2c());
            session = new Snmp(disp, transport);
        } else {
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            usm.addUser(this.getSecurityName(), new UsmUser(this.getSecurityName(), this.getAuthProtocol(), this.getAuthPassPhrase(), this.getPrivProtocol(), this.getPrivPassPhrase()));
            disp.addMessageProcessingModel(new MPv3(usm));
            session = new Snmp(disp, transport);
        }
        return session;
    }

    public PDU createPdu(int type) {
        PDU pdu = null;
        if (this.isSnmpV3()) {
            OctetString contextEngineID;
            PDU scopedPDU = pdu = new ScopedPDU();
            OctetString contextName = this.getContextName();
            if (contextName != null) {
                ((ScopedPDU)scopedPDU).setContextName(contextName);
            }
            if ((contextEngineID = this.getContextEngineID()) != null) {
                ((ScopedPDU)scopedPDU).setContextEngineID(contextEngineID);
            }
        } else {
            pdu = new PDU();
        }
        pdu.setType(type);
        return pdu;
    }
}

