/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.util.Assert;

public class XRequestedWithAwareLoginUrlAuthEntryPoint
extends LoginUrlAuthenticationEntryPoint
implements InitializingBean {
    private String realmName;

    public XRequestedWithAwareLoginUrlAuthEntryPoint(String loginUrl) {
        super(loginUrl);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.realmName, (String)"realmName must be specified");
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String requestedWithValue = request.getHeader("X-Requested-With");
        if (requestedWithValue != null && requestedWithValue.equals("XMLHttpRequest")) {
            response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
            response.sendError(401, authException.getMessage());
        } else {
            super.commence(request, response, authException);
        }
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

