/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Collection;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.kerberos.authentication.KerberosAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class KerberosLdapAuthenticationProvider
extends KerberosAuthenticationProvider {
    private KerberosClient m_kerberosClient;
    private LdapUserSearch m_ldapUserSearch;
    private LdapAuthoritiesPopulator m_ldapAuthoritiesPopulator;
    private boolean m_trimRealm = true;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken auth = (UsernamePasswordAuthenticationToken)authentication;
        String validatedUsername = this.trimRealmFromUsername(this.m_kerberosClient.login(auth.getName(), auth.getCredentials().toString()));
        DirContextOperations ldapUserEntry = this.m_ldapUserSearch.searchForUser(validatedUsername);
        Collection grantedAuthorities = this.m_ldapAuthoritiesPopulator.getGrantedAuthorities(ldapUserEntry, validatedUsername);
        User userDetails = new User(validatedUsername, "notUsed", true, true, true, true, grantedAuthorities);
        UsernamePasswordAuthenticationToken output = new UsernamePasswordAuthenticationToken((Object)userDetails, auth.getCredentials(), grantedAuthorities);
        return output;
    }

    private String trimRealmFromUsername(String username) {
        if (this.m_trimRealm && username.contains("@")) {
            return username.substring(0, username.indexOf("@"));
        }
        return username;
    }

    public void setLdapAuthoritiesPopulator(LdapAuthoritiesPopulator ldapAuthoritiesPopulator) {
        this.m_ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
    }

    public LdapAuthoritiesPopulator getLdapAuthoritiesPopulator() {
        return this.m_ldapAuthoritiesPopulator;
    }

    public void setLdapUserSearch(LdapUserSearch ldapUserSearch) {
        this.m_ldapUserSearch = ldapUserSearch;
    }

    public LdapUserSearch getLdapUserSearch() {
        return this.m_ldapUserSearch;
    }

    public void setKerberosClient(KerberosClient kerberosClient) {
        this.m_kerberosClient = kerberosClient;
    }

    public KerberosClient getKerberosClient() {
        return this.m_kerberosClient;
    }

    public void setTrimRealm(boolean trimRealm) {
        this.m_trimRealm = trimRealm;
    }

    public boolean getTrimRealm() {
        return this.m_trimRealm;
    }
}

