/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.opennms.core.utils.ImmutableCollections;
import org.opennms.core.utils.MutableCollections;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.events.api.model.IAlarmData;
import org.opennms.netmgt.events.api.model.IAutoAcknowledge;
import org.opennms.netmgt.events.api.model.IAutoAction;
import org.opennms.netmgt.events.api.model.ICorrelation;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IForward;
import org.opennms.netmgt.events.api.model.ILogMsg;
import org.opennms.netmgt.events.api.model.IMask;
import org.opennms.netmgt.events.api.model.IOperAction;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.IScript;
import org.opennms.netmgt.events.api.model.ISnmp;
import org.opennms.netmgt.events.api.model.ITticket;
import org.opennms.netmgt.events.api.model.ImmutableAlarmData;
import org.opennms.netmgt.events.api.model.ImmutableAutoAcknowledge;
import org.opennms.netmgt.events.api.model.ImmutableAutoAction;
import org.opennms.netmgt.events.api.model.ImmutableCorrelation;
import org.opennms.netmgt.events.api.model.ImmutableForward;
import org.opennms.netmgt.events.api.model.ImmutableLogMsg;
import org.opennms.netmgt.events.api.model.ImmutableMask;
import org.opennms.netmgt.events.api.model.ImmutableOperAction;
import org.opennms.netmgt.events.api.model.ImmutableParm;
import org.opennms.netmgt.events.api.model.ImmutableScript;
import org.opennms.netmgt.events.api.model.ImmutableSnmp;
import org.opennms.netmgt.events.api.model.ImmutableTticket;

public final class ImmutableEvent
implements IEvent {
    private final String uuid;
    private final Long dbId;
    private final String distPoller;
    private final Date creationTime;
    private final String masterStation;
    private final IMask mask;
    private final String uei;
    private final String source;
    private final Long nodeid;
    private final Date time;
    private final String host;
    private final InetAddress interfaceAddress;
    private final String interfaceString;
    private final String snmpHost;
    private final String service;
    private final ISnmp snmp;
    private final List<IParm> parms;
    private final String descr;
    private final ILogMsg logMsg;
    private final String severity;
    private final String pathOutage;
    private final ICorrelation correlation;
    private final String operInstruct;
    private final List<IAutoAction> autoActionList;
    private final List<IOperAction> operActionList;
    private final IAutoAcknowledge autoAcknowledge;
    private final List<String> logGroupList;
    private final ITticket tTicket;
    private final List<IForward> forwardList;
    private final List<IScript> scriptList;
    private final Integer ifIndex;
    private final String ifAlias;
    private final String mouseOverText;
    private final IAlarmData alarmData;

    private ImmutableEvent(Builder builder) {
        this.uuid = builder.uuid;
        this.dbId = builder.dbId;
        this.distPoller = builder.distPoller;
        this.creationTime = builder.creationTime;
        this.masterStation = builder.masterStation;
        this.mask = ImmutableMask.immutableCopy(builder.mask);
        this.uei = builder.uei;
        this.source = builder.source;
        this.nodeid = builder.nodeid;
        this.time = builder.time;
        this.host = builder.host;
        this.interfaceAddress = builder.interfaceAddress;
        this.interfaceString = builder.interfaceString;
        this.snmpHost = builder.snmpHost;
        this.service = builder.service;
        this.snmp = ImmutableSnmp.immutableCopy(builder.snmp);
        this.parms = ImmutableCollections.with(ImmutableParm::immutableCopy).newList(builder.parms);
        this.descr = builder.descr;
        this.logMsg = ImmutableLogMsg.immutableCopy(builder.logMsg);
        this.severity = builder.severity;
        this.pathOutage = builder.pathOutage;
        this.correlation = ImmutableCorrelation.immutableCopy(builder.correlation);
        this.operInstruct = builder.operInstruct;
        this.autoActionList = ImmutableCollections.with(ImmutableAutoAction::immutableCopy).newList(builder.autoActionList);
        this.operActionList = ImmutableCollections.with(ImmutableOperAction::immutableCopy).newList(builder.operActionList);
        this.autoAcknowledge = ImmutableAutoAcknowledge.immutableCopy(builder.autoAcknowledge);
        this.logGroupList = ImmutableCollections.newListOfImmutableType(builder.logGroupList);
        this.tTicket = ImmutableTticket.immutableCopy(builder.tTicket);
        this.forwardList = ImmutableCollections.with(ImmutableForward::immutableCopy).newList(builder.forwardList);
        this.scriptList = ImmutableCollections.with(ImmutableScript::immutableCopy).newList(builder.scriptList);
        this.ifIndex = builder.ifIndex;
        this.ifAlias = builder.ifAlias;
        this.mouseOverText = builder.mouseOverText;
        this.alarmData = ImmutableAlarmData.immutableCopy(builder.alarmData);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IEvent event) {
        return new Builder(event);
    }

    public static IEvent immutableCopy(IEvent event) {
        if (event == null || event instanceof ImmutableEvent) {
            return event;
        }
        return ImmutableEvent.newBuilderFrom(event).build();
    }

    @Override
    public IAlarmData getAlarmData() {
        return this.alarmData;
    }

    @Override
    public IAutoAcknowledge getAutoacknowledge() {
        return this.autoAcknowledge;
    }

    @Override
    public IAutoAction getAutoaction(int index) {
        if (index < 0 || index >= this.autoActionList.size()) {
            throw new IndexOutOfBoundsException("getAutoaction: Index value '" + index + "' not in range [0.." + (this.autoActionList.size() - 1) + "]");
        }
        return this.autoActionList.get(index);
    }

    @Override
    public IAutoAction[] getAutoaction() {
        return this.autoActionList.toArray(new IAutoAction[0]);
    }

    @Override
    public List<IAutoAction> getAutoactionCollection() {
        return this.autoActionList;
    }

    @Override
    public int getAutoactionCount() {
        return this.autoActionList.size();
    }

    @Override
    public ICorrelation getCorrelation() {
        return this.correlation;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime == null ? null : new Date(this.creationTime.getTime());
    }

    @Override
    public Long getDbid() {
        return this.dbId == null ? 0L : this.dbId;
    }

    @Override
    public String getDescr() {
        return this.descr;
    }

    @Override
    public String getDistPoller() {
        return this.distPoller;
    }

    @Override
    public IForward getForward(int index) {
        if (index < 0 || index >= this.forwardList.size()) {
            throw new IndexOutOfBoundsException("getForward: Index value '" + index + "' not in range [0.." + (this.forwardList.size() - 1) + "]");
        }
        return this.forwardList.get(index);
    }

    @Override
    public IForward[] getForward() {
        return this.forwardList.toArray(new IForward[0]);
    }

    @Override
    public List<IForward> getForwardCollection() {
        return this.forwardList;
    }

    @Override
    public int getForwardCount() {
        return this.forwardList.size();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getIfAlias() {
        return this.ifAlias;
    }

    @Override
    public Integer getIfIndex() {
        return this.ifIndex == null ? 0 : this.ifIndex;
    }

    @Override
    public String getInterface() {
        return this.interfaceString;
    }

    @Override
    public InetAddress getInterfaceAddress() {
        return this.interfaceAddress;
    }

    @Override
    public String getLoggroup(int index) {
        if (index < 0 || index >= this.logGroupList.size()) {
            throw new IndexOutOfBoundsException("getLoggroup: Index value '" + index + "' not in range [0.." + (this.logGroupList.size() - 1) + "]");
        }
        return this.logGroupList.get(index);
    }

    @Override
    public String[] getLoggroup() {
        return this.logGroupList.toArray(new String[0]);
    }

    @Override
    public List<String> getLoggroupCollection() {
        return this.logGroupList;
    }

    @Override
    public int getLoggroupCount() {
        return this.logGroupList.size();
    }

    @Override
    public ILogMsg getLogmsg() {
        return this.logMsg;
    }

    @Override
    public IMask getMask() {
        return this.mask;
    }

    @Override
    public String getMasterStation() {
        return this.masterStation;
    }

    @Override
    public String getMouseovertext() {
        return this.mouseOverText;
    }

    @Override
    public Long getNodeid() {
        return this.nodeid == null ? 0L : this.nodeid;
    }

    @Override
    public IOperAction getOperaction(int index) {
        if (index < 0 || index >= this.operActionList.size()) {
            throw new IndexOutOfBoundsException("getOperaction: Index value '" + index + "' not in range [0.." + (this.operActionList.size() - 1) + "]");
        }
        return this.operActionList.get(index);
    }

    @Override
    public IOperAction[] getOperaction() {
        return this.operActionList.toArray(new IOperAction[0]);
    }

    @Override
    public List<IOperAction> getOperactionCollection() {
        return this.operActionList;
    }

    @Override
    public int getOperactionCount() {
        return this.operActionList.size();
    }

    @Override
    public String getOperinstruct() {
        return this.operInstruct;
    }

    @Override
    public List<IParm> getParmCollection() {
        return this.parms == null ? Collections.emptyList() : this.parms;
    }

    @Override
    public IParm getParm(String key) {
        if (this.parms == null) {
            return null;
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key cannot be null!");
        }
        return this.parms.stream().filter(p -> Objects.equals(key, p.getParmName())).findFirst().orElse(null);
    }

    @Override
    public IParm getParmTrim(String key) {
        if (this.parms == null) {
            return null;
        }
        return this.parms.stream().filter(p -> StringUtils.equalsTrimmed((String)key, (String)p.getParmName())).findFirst().orElse(null);
    }

    @Override
    public String getPathoutage() {
        return this.pathOutage;
    }

    @Override
    public IScript getScript(int index) {
        if (index < 0 || index >= this.scriptList.size()) {
            throw new IndexOutOfBoundsException("getScript: Index value '" + index + "' not in range [0.." + (this.scriptList.size() - 1) + "]");
        }
        return this.scriptList.get(index);
    }

    @Override
    public IScript[] getScript() {
        return this.scriptList.toArray(new IScript[0]);
    }

    @Override
    public List<IScript> getScriptCollection() {
        return this.scriptList;
    }

    @Override
    public int getScriptCount() {
        return this.scriptList.size();
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    @Override
    public ISnmp getSnmp() {
        return this.snmp;
    }

    @Override
    public String getSnmphost() {
        return this.snmpHost;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Date getTime() {
        return this.time == null ? null : new Date(this.time.getTime());
    }

    @Override
    public ITticket getTticket() {
        return this.tTicket;
    }

    @Override
    public String getUei() {
        return this.uei;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean hasDbid() {
        return this.dbId != null;
    }

    @Override
    public boolean hasIfIndex() {
        return this.ifIndex != null;
    }

    @Override
    public boolean hasNodeid() {
        return this.nodeid != null;
    }

    @Override
    public Enumeration<IAutoAction> enumerateAutoaction() {
        return Collections.enumeration(this.autoActionList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableEvent that = (ImmutableEvent)o;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.dbId, that.dbId) && Objects.equals(this.distPoller, that.distPoller) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.masterStation, that.masterStation) && Objects.equals(this.mask, that.mask) && Objects.equals(this.uei, that.uei) && Objects.equals(this.source, that.source) && Objects.equals(this.nodeid, that.nodeid) && Objects.equals(this.time, that.time) && Objects.equals(this.host, that.host) && Objects.equals(this.snmpHost, that.snmpHost) && Objects.equals(this.service, that.service) && Objects.equals(this.snmp, that.snmp) && Objects.equals(this.parms, that.parms) && Objects.equals(this.descr, that.descr) && Objects.equals(this.logMsg, that.logMsg) && Objects.equals(this.severity, that.severity) && Objects.equals(this.pathOutage, that.pathOutage) && Objects.equals(this.correlation, that.correlation) && Objects.equals(this.operInstruct, that.operInstruct) && Objects.equals(this.autoActionList, that.autoActionList) && Objects.equals(this.operActionList, that.operActionList) && Objects.equals(this.autoAcknowledge, that.autoAcknowledge) && Objects.equals(this.logGroupList, that.logGroupList) && Objects.equals(this.tTicket, that.tTicket) && Objects.equals(this.forwardList, that.forwardList) && Objects.equals(this.scriptList, that.scriptList) && Objects.equals(this.ifIndex, that.ifIndex) && Objects.equals(this.ifAlias, that.ifAlias) && Objects.equals(this.mouseOverText, that.mouseOverText) && Objects.equals(this.alarmData, that.alarmData);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.dbId, this.distPoller, this.creationTime, this.masterStation, this.mask, this.uei, this.source, this.nodeid, this.time, this.host, this.snmpHost, this.service, this.snmp, this.parms, this.descr, this.logMsg, this.severity, this.pathOutage, this.correlation, this.operInstruct, this.autoActionList, this.operActionList, this.autoAcknowledge, this.logGroupList, this.tTicket, this.forwardList, this.scriptList, this.ifIndex, this.ifAlias, this.mouseOverText, this.alarmData);
    }

    public String toString() {
        return "ImmutableEvent{uuid='" + this.uuid + "', dbId=" + this.dbId + ", distPoller='" + this.distPoller + "', creationTime=" + String.valueOf(this.creationTime) + ", masterStation='" + this.masterStation + "', mask=" + String.valueOf(this.mask) + ", uei='" + this.uei + "', source='" + this.source + "', nodeid=" + this.nodeid + ", time=" + String.valueOf(this.time) + ", host='" + this.host + "', interfaceAddress=" + String.valueOf(this.interfaceAddress) + ", interfaceString='" + this.interfaceString + "', snmpHost='" + this.snmpHost + "', service='" + this.service + "', snmp=" + String.valueOf(this.snmp) + ", parms=" + String.valueOf(this.parms) + ", descr='" + this.descr + "', logMsg=" + String.valueOf(this.logMsg) + ", severity='" + this.severity + "', pathOutage='" + this.pathOutage + "', correlation=" + String.valueOf(this.correlation) + ", operInstruct='" + this.operInstruct + "', autoActionList=" + String.valueOf(this.autoActionList) + ", operActionList=" + String.valueOf(this.operActionList) + ", autoAcknowledge=" + String.valueOf(this.autoAcknowledge) + ", logGroupList=" + String.valueOf(this.logGroupList) + ", tTicket=" + String.valueOf(this.tTicket) + ", forwardList=" + String.valueOf(this.forwardList) + ", scriptList=" + String.valueOf(this.scriptList) + ", ifIndex=" + this.ifIndex + ", ifAlias='" + this.ifAlias + "', mouseOverText='" + this.mouseOverText + "', alarmData=" + String.valueOf(this.alarmData) + "}";
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
        builder.append("uei", (Object)this.uei);
        builder.append("time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSSZ").format(this.time));
        if (this.dbId != null) {
            builder.append("dbid", (Object)this.dbId);
        }
        if (this.source != null) {
            builder.append("source", (Object)this.source);
        }
        if (this.nodeid != null) {
            builder.append("nodeid", (Object)this.nodeid);
        }
        if (this.parms != null) {
            builder.append("parms", this.parms);
        }
        return builder.toString();
    }

    public static final class Builder {
        private String uuid;
        private Long dbId;
        private String distPoller;
        private Date creationTime;
        private String masterStation;
        private IMask mask;
        private String uei;
        private String source;
        private Long nodeid;
        private Date time;
        private String host;
        private InetAddress interfaceAddress;
        private String interfaceString;
        private String snmpHost;
        private String service;
        private ISnmp snmp;
        private List<IParm> parms;
        private String descr;
        private ILogMsg logMsg;
        private String severity;
        private String pathOutage;
        private ICorrelation correlation;
        private String operInstruct;
        private List<IAutoAction> autoActionList;
        private List<IOperAction> operActionList;
        private IAutoAcknowledge autoAcknowledge;
        private List<String> logGroupList;
        private ITticket tTicket;
        private List<IForward> forwardList;
        private List<IScript> scriptList;
        private Integer ifIndex;
        private String ifAlias;
        private String mouseOverText;
        private IAlarmData alarmData;

        private Builder() {
        }

        private Builder(IEvent event) {
            this.uuid = event.getUuid();
            this.dbId = event.getDbid();
            this.distPoller = event.getDistPoller();
            this.creationTime = new Date(event.getCreationTime().getTime());
            this.masterStation = event.getMasterStation();
            this.mask = event.getMask();
            this.uei = event.getUei();
            this.source = event.getSource();
            this.nodeid = event.getNodeid();
            this.time = new Date(event.getTime().getTime());
            this.host = event.getHost();
            this.interfaceAddress = event.getInterfaceAddress();
            this.interfaceString = event.getInterface();
            this.snmpHost = event.getSnmphost();
            this.service = event.getService();
            this.snmp = event.getSnmp();
            this.parms = MutableCollections.copyListFromNullable(event.getParmCollection());
            this.descr = event.getDescr();
            this.logMsg = event.getLogmsg();
            this.severity = event.getSeverity();
            this.pathOutage = event.getPathoutage();
            this.correlation = event.getCorrelation();
            this.operInstruct = event.getOperinstruct();
            this.autoActionList = MutableCollections.copyListFromNullable(event.getAutoactionCollection());
            this.operActionList = MutableCollections.copyListFromNullable(event.getOperactionCollection());
            this.autoAcknowledge = event.getAutoacknowledge();
            this.logGroupList = MutableCollections.copyListFromNullable(event.getLoggroupCollection());
            this.tTicket = event.getTticket();
            this.forwardList = MutableCollections.copyListFromNullable(event.getForwardCollection());
            this.scriptList = MutableCollections.copyListFromNullable(event.getScriptCollection());
            this.ifIndex = event.getIfIndex();
            this.ifAlias = event.getIfAlias();
            this.mouseOverText = event.getMouseovertext();
            this.alarmData = event.getAlarmData();
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setDbId(Long dbId) {
            this.dbId = dbId;
            return this;
        }

        public Builder setDistPoller(String distPoller) {
            this.distPoller = distPoller;
            return this;
        }

        public Builder setCreationTime(Date creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setMasterStation(String masterStation) {
            this.masterStation = masterStation;
            return this;
        }

        public Builder setMask(IMask mask) {
            this.mask = mask;
            return this;
        }

        public Builder setUei(String uei) {
            this.uei = uei;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setNodeid(Long nodeid) {
            this.nodeid = nodeid;
            return this;
        }

        public Builder setTime(Date time) {
            this.time = time;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setInterfaceAddress(InetAddress interfaceAddress) {
            this.interfaceAddress = interfaceAddress;
            return this;
        }

        public Builder setInterface(String interfaceString) {
            this.interfaceString = interfaceString;
            return this;
        }

        public Builder setSnmpHost(String snmpHost) {
            this.snmpHost = snmpHost;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setSnmp(ISnmp snmp) {
            this.snmp = snmp;
            return this;
        }

        public Builder setParms(List<IParm> parms) {
            this.parms = parms;
            return this;
        }

        public Builder setDescr(String descr) {
            this.descr = descr;
            return this;
        }

        public Builder setLogMsg(ILogMsg logMsg) {
            this.logMsg = logMsg;
            return this;
        }

        public Builder setSeverity(String severity) {
            this.severity = severity;
            return this;
        }

        public Builder setPathOutage(String pathOutage) {
            this.pathOutage = pathOutage;
            return this;
        }

        public Builder setCorrelation(ICorrelation correlation) {
            this.correlation = correlation;
            return this;
        }

        public Builder setOperInstruct(String operInstruct) {
            this.operInstruct = operInstruct;
            return this;
        }

        public Builder setAutoActionList(List<IAutoAction> autoActionList) {
            this.autoActionList = autoActionList;
            return this;
        }

        public Builder setOperActionList(List<IOperAction> operActionList) {
            this.operActionList = operActionList;
            return this;
        }

        public Builder setAutoAcknowledge(IAutoAcknowledge autoAcknowledge) {
            this.autoAcknowledge = autoAcknowledge;
            return this;
        }

        public Builder setLogGroupList(List<String> logGroupList) {
            this.logGroupList = logGroupList;
            return this;
        }

        public Builder settTicket(ITticket tTicket) {
            this.tTicket = tTicket;
            return this;
        }

        public Builder setForwardList(List<IForward> forwardList) {
            this.forwardList = forwardList;
            return this;
        }

        public Builder setScriptList(List<IScript> scriptList) {
            this.scriptList = scriptList;
            return this;
        }

        public Builder setIfIndex(Integer ifIndex) {
            this.ifIndex = ifIndex;
            return this;
        }

        public Builder setIfAlias(String ifAlias) {
            this.ifAlias = ifAlias;
            return this;
        }

        public Builder setMouseOverText(String mouseOverText) {
            this.mouseOverText = mouseOverText;
            return this;
        }

        public Builder setAlarmData(IAlarmData alarmData) {
            this.alarmData = alarmData;
            return this;
        }

        public ImmutableEvent build() {
            return new ImmutableEvent(this);
        }
    }
}

