/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jdbc;

import org.opennms.netmgt.provision.detector.jdbc.AbstractJdbcDetector;
import org.opennms.netmgt.provision.detector.jdbc.request.JDBCRequest;
import org.opennms.netmgt.provision.detector.jdbc.response.JDBCResponse;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;

public class JdbcQueryDetector
extends AbstractJdbcDetector {
    private String m_sqlQuery;

    public JdbcQueryDetector() {
        super("JdbcQueryDetector", 3306);
    }

    protected void onInit() {
        this.expectBanner(JdbcQueryDetector.resultSetNotNull());
        this.send(JdbcQueryDetector.sqlQuery(this.getSqlQuery()), JdbcQueryDetector.isValidQuery());
    }

    private static ResponseValidator<JDBCResponse> isValidQuery() {
        return new ResponseValidator<JDBCResponse>(){

            public boolean validate(JDBCResponse response) {
                return response.isValidQuery();
            }
        };
    }

    private static RequestBuilder<JDBCRequest> sqlQuery(final String sqlQuery) {
        return new RequestBuilder<JDBCRequest>(){

            public JDBCRequest getRequest() {
                JDBCRequest request = new JDBCRequest();
                request.setSqyQuery(sqlQuery);
                return request;
            }
        };
    }

    public void setSqlQuery(String sqlQuery) {
        this.m_sqlQuery = sqlQuery;
    }

    public String getSqlQuery() {
        return this.m_sqlQuery;
    }
}

