/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.snmp.AddressSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Configuration;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.SnmpProfiles;

@XmlRootElement(name="snmp-config")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="snmp-config.xsd")
public class SnmpConfig
extends Configuration
implements Serializable {
    private static final long serialVersionUID = -5963402509661530467L;
    @XmlElement(name="definition")
    private List<Definition> m_definitions = new ArrayList<Definition>();
    @XmlElement(name="profiles")
    private SnmpProfiles m_snmpProfiles;

    public SnmpConfig() {
    }

    public SnmpConfig(Integer port, Integer retry, Integer timeout, String readCommunity, String writeCommunity, String proxyHost, String version, Integer maxVarsPerPdu, Integer maxRepetitions, Integer maxRequestSize, String securityName, Integer securityLevel, String authPassphrase, String authProtocol, String engineId, String contextEngineId, String contextName, String privacyPassphrase, String privacyProtocol, String enterpriseId, List<Definition> definitions) {
        super(port, retry, timeout, readCommunity, writeCommunity, proxyHost, version, maxVarsPerPdu, maxRepetitions, maxRequestSize, securityName, securityLevel, authPassphrase, authProtocol, engineId, contextEngineId, contextName, privacyPassphrase, privacyProtocol, enterpriseId);
        this.setDefinitions(definitions);
    }

    public List<Definition> getDefinitions() {
        if (this.m_definitions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_definitions);
    }

    public void setDefinitions(List<Definition> definitions) {
        this.m_definitions = new ArrayList<Definition>(definitions);
    }

    public void addDefinition(Definition definitions) throws IndexOutOfBoundsException {
        this.m_definitions.add(definitions);
    }

    public boolean removeDefinition(Definition definitions) {
        return this.m_definitions.remove(definitions);
    }

    public SnmpProfiles getSnmpProfiles() {
        return this.m_snmpProfiles;
    }

    public void setSnmpProfiles(SnmpProfiles snmpProfiles) {
        this.m_snmpProfiles = snmpProfiles;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_definitions == null ? 0 : this.m_definitions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SnmpConfig)) {
            return false;
        }
        SnmpConfig other = (SnmpConfig)obj;
        return !(this.m_definitions == null ? other.m_definitions != null : !this.m_definitions.equals(other.m_definitions));
    }

    @Override
    public String toString() {
        return "SnmpConfig [definitions=" + String.valueOf(this.m_definitions) + "]";
    }

    public void visit(SnmpConfigVisitor visitor) {
        visitor.visitSnmpConfig(this);
        for (Definition definition : this.m_definitions) {
            definition.visit(visitor);
        }
        visitor.visitSnmpConfigFinished();
    }

    public Definition findDefinition(InetAddress agentInetAddress) {
        AddressSnmpConfigVisitor visitor = new AddressSnmpConfigVisitor(agentInetAddress);
        this.visit(visitor);
        return visitor.getDefinition();
    }
}

